/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.guest;

import javax.mail.internet.MimeMessage;
import com.openexchange.exception.OXException;
import com.openexchange.guard.caching.GenericCache;
import com.openexchange.guard.caching.GenericCacheFactory;
import com.openexchange.guard.email.storage.ogEmail.Email;
import com.openexchange.guard.guest.metadata.storage.GuardGuestEmailMetadata;

/**
 * A caching service to keep in local memory Guest items such as metaData, emails, and mappings
 * {@link GuestCacheService}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.0
 * @deprecated Use {@link GenericCache} and {@link GenericCacheFactory} instead.
 */
@Deprecated
public interface GuestCacheService {

    /**
     * Gets the metaData for an itemId if exists in cache
     * @param contextId
     * @param userId
     * @param itemId
     * @return
     * @throws OXException
     */
    public GuardGuestEmailMetadata getMetaData(int contextId, int userId, String itemId) throws OXException;

    /**
     * Adds the meta data to the cache for specific itemId
     * @param contextId
     * @param userId
     * @param itemId
     * @param meta
     * @throws OXException
     */
    public void addMetaData(int contextId, int userId, String itemId, GuardGuestEmailMetadata meta) throws OXException;

    /**
     * Saves a guest message to the cache
     * @param contextId
     * @param itemId
     * @param msg
     * @throws OXException
     */
    public void putMessage (int contextId, String itemId, MimeMessage msg) throws OXException;

    /**
     * Gets a cached message from the cache.  Null if not found
     * @param contextId
     * @param itemId
     * @return
     * @throws OXException
     */
    public MimeMessage getMessage (int contextId, String itemId) throws OXException;

    /**
     * Gets a reference from an OX Guest userid/context to a Guard account
     * @param contextId
     * @param userId
     * @return
     * @throws OXException
     */
    public Email getGuest(int contextId, int userId) throws OXException;

    /**
     * Puts a reference from an OX Guest userid/context to a Guard account
     * @param contextId
     * @param userId
     * @param email
     * @throws OXException
     */
    public void putGuest(int contextId, int userId, Email email) throws OXException;
}
