/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.database.init;

import com.openexchange.database.AbstractCreateTableImpl;
import com.openexchange.database.CreateTableService;

/**
 *
 * {@link CreateTableService} to add guard related tables to ox user schemata.<br>
 * <br>
 * In addition these statements are used to create new guest shards.
 *
 * @author <a href="mailto:martin.schneider@open-xchange.com">Martin Schneider</a>
 * @since 2.4.0
 */
public final class GuardCreateTableService extends AbstractCreateTableImpl {

    private static final String KEY_TABLE = "og_KeyTable";

    private static final String KEY_TABLE_CREATE_STMT = "CREATE TABLE " + KEY_TABLE + " (\n" +
        "  id int(11) NOT NULL AUTO_INCREMENT,\n" +
        "  PGPSecret text COLLATE utf8_unicode_ci,\n" +
        "  PGPPublic mediumtext COLLATE utf8_unicode_ci,\n" +
        "  RSAPrivate varchar(6000) COLLATE utf8_unicode_ci,\n" +
        "  RSAPublic varchar(2000) COLLATE utf8_unicode_ci,\n" +
        "  Recovery varchar(2000) COLLATE utf8_unicode_ci,\n" +
        "  Salt varchar(40) COLLATE utf8_unicode_ci,\n" +
        "  cid int(11) NOT NULL DEFAULT '0',\n" +
        "  email varchar(250) COLLATE utf8_unicode_ci NOT NULL,\n" +
        "  lastMod date DEFAULT NULL,\n" +
        "  question varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,\n" +
        "  answer varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL,\n" +
        "  misc varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,\n" +
        "  lang  varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL,\n" +
        "  settings varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL,\n" +
        "  current bit(1) NOT NULL DEFAULT b'1',\n" +
        "  keyid bigint(20) NOT NULL DEFAULT '0',\n" +
        "  version int(10) unsigned zerofill NOT NULL DEFAULT '0000000000',\n" +
        "  inline bit(1) NOT NULL DEFAULT b'0',\n" +
        "  PRIMARY KEY (id, cid, keyid),\n" +
        "  KEY email (email)\n" +
        ") ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

    private static final String OG_PGP_KEYS_TABLE = "og_pgp_keys";

    private static final String OG_PGP_KEYS_TABLE_CREATE_STMT = "CREATE TABLE " + OG_PGP_KEYS_TABLE + " (\n" +
        "  ids varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',\n" +
        "  Email varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',\n" +
        "  PGPPublic mediumtext COLLATE utf8_unicode_ci DEFAULT NULL,\n" +
        "  userid int(11) NOT NULL DEFAULT '0',\n" +
        "  cid int(11) NOT NULL DEFAULT '0',\n" +
        "  share_level int(11) DEFAULT NULL,\n" +
        "  inline bit(1) DEFAULT b'0',\n" +
        "  PRIMARY KEY (Email,cid,userid),\n" +
        "  KEY id (ids)\n" +
        ") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

    private static final String ENCRYPTED_ITEMS_TABLE = "og_encrypted_items";

    private static final String ENCRYPTED_ITEMS_TABLE_CREATE_STMT = "CREATE TABLE " + ENCRYPTED_ITEMS_TABLE + " (\n" +
        "  Id varchar(38) NOT NULL,\n"+
        "  Owner int(11) DEFAULT NULL,\n" +
        "  Expiration bigint(20) DEFAULT NULL,\n" +
        "  Type int(11) DEFAULT NULL,\n" +
        "  XML varchar(10000) DEFAULT NULL,\n" +
        "  Owner_cid int(11) DEFAULT NULL,\n"+
        "  Salt varchar(50) DEFAULT NULL,\n" +
        "  PRIMARY KEY (Id(36))\n" +
        ") ENGINE=InnoDB DEFAULT CHARSET=utf8;"; //TODO fehlt hier nicht das COLLATE=utf...?

    private static final String MAILVELOPE_TABLE = "og_mailvelope";

    private static final String CREATE_MAILVELOPE_TABLE = "CREATE TABLE og_mailvelope (" +
            "`id`  int NOT NULL , " +
            "`cid`  int NOT NULL , " +
            "`keydata`  mediumtext NULL , "+
            "PRIMARY KEY (`id`, `cid`)" +
            ") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

    /**
     * Gets the table names.
     *
     * @return The table names.
     */
    public static String[] getTablesToCreate() {
        return new String[] { ENCRYPTED_ITEMS_TABLE, KEY_TABLE, OG_PGP_KEYS_TABLE, MAILVELOPE_TABLE };
    }

    /**
     * Gets the CREATE-TABLE statements.
     *
     * @return The CREATE statements
     */
    public static String[] getCreateStmts() {
        return new String[] { ENCRYPTED_ITEMS_TABLE_CREATE_STMT, KEY_TABLE_CREATE_STMT, OG_PGP_KEYS_TABLE_CREATE_STMT, CREATE_MAILVELOPE_TABLE };
    }

    /**
     * Initializes a new {@link GuardCreateTableService}.
     */
    public GuardCreateTableService() {
        super();
    }

    @Override
    public String[] requiredTables() {
        return NO_TABLES;
    }

    @Override
    public String[] tablesToCreate() {
        return getTablesToCreate();
    }

    @Override
    protected String[] getCreateStatements() {
        return getCreateStmts();
    }

}
