/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

import com.j256.simplemagic.endian.EndianConverter;
import com.j256.simplemagic.endian.EndianType;
import com.j256.simplemagic.entries.MagicFormatter;
import com.j256.simplemagic.entries.MagicMatcher;

public class DoubleType
implements MagicMatcher {
    private final EndianConverter endianConverter;

    public DoubleType(EndianType endianType) {
        this.endianConverter = endianType.getConverter();
    }

    public Object convertTestString(String typeStr, String testStr) {
        try {
            return Double.parseDouble(testStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse double from: " + testStr);
        }
    }

    public Object extractValueFromBytes(int offset, byte[] bytes) {
        Long val = this.endianConverter.convertNumber(offset, bytes, 8);
        if (val == null) {
            return null;
        }
        return Double.longBitsToDouble(val);
    }

    public Object isMatch(Object testValue, Long andValue, boolean unsignedType, Object extractedValue, MagicMatcher.MutableOffset mutableOffset, byte[] bytes) {
        if (testValue.equals(extractedValue)) {
            mutableOffset.offset += 8;
            return extractedValue;
        }
        return null;
    }

    public void renderValue(StringBuilder sb, Object extractedValue, MagicFormatter formatter) {
        formatter.format(sb, extractedValue);
    }

    public byte[] getStartingBytes(Object testValue) {
        return null;
    }
}

