/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic;

import com.j256.simplemagic.ContentInfo;
import com.j256.simplemagic.ContentType;
import com.j256.simplemagic.entries.MagicEntries;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;

public class ContentInfoUtil {
    private static final String INTERNAL_MAGIC_FILE = "/magic.gz";
    public static final int DEFAULT_READ_SIZE = 10240;
    private static MagicEntries internalMagicEntries;
    private final MagicEntries magicEntries;
    private int fileReadSize = 10240;
    private ErrorCallBack errorCallBack;

    public ContentInfoUtil() {
        this((ErrorCallBack)null);
    }

    public ContentInfoUtil(ErrorCallBack errorCallBack) {
        this.errorCallBack = errorCallBack;
        if (internalMagicEntries == null) {
            try {
                internalMagicEntries = this.readEntriesFromResource(INTERNAL_MAGIC_FILE);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not load entries from internal magic file: /magic.gz", e);
            }
            if (internalMagicEntries == null) {
                throw new IllegalStateException("Internal magic file not found in class-path: /magic.gz");
            }
        }
        this.magicEntries = internalMagicEntries;
    }

    public ContentInfoUtil(String fileOrDirectoryPath) throws IOException {
        this(new File(fileOrDirectoryPath), null);
    }

    public ContentInfoUtil(String fileOrDirectoryOrResourcePath, ErrorCallBack errorCallBack) throws IOException {
        this.errorCallBack = errorCallBack;
        MagicEntries magicEntries = this.readEntriesFromResource(fileOrDirectoryOrResourcePath);
        if (magicEntries == null) {
            File file = new File(fileOrDirectoryOrResourcePath);
            magicEntries = this.readEntriesFromFile(file);
        }
        if (magicEntries == null) {
            throw new IllegalArgumentException("Magic path specified is not a file, directory, or resource: " + fileOrDirectoryOrResourcePath);
        }
        this.magicEntries = magicEntries;
    }

    public ContentInfoUtil(File fileOrDirectory) throws IOException {
        this(fileOrDirectory, null);
    }

    public ContentInfoUtil(File fileOrDirectory, ErrorCallBack errorCallBack) throws IOException {
        this.errorCallBack = errorCallBack;
        this.magicEntries = this.readEntriesFromFile(fileOrDirectory);
        if (this.magicEntries == null) {
            throw new IllegalArgumentException("Magic path specified is not a file, directory, or resource: " + fileOrDirectory);
        }
    }

    public ContentInfo findMatch(String filePath) throws IOException {
        return this.findMatch(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentInfo findMatch(File file) throws IOException {
        int readSize = this.fileReadSize;
        if (file.length() < (long)readSize) {
            readSize = (int)file.length();
        }
        byte[] bytes = new byte[readSize];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            fis.read(bytes);
        }
        finally {
            this.closeQuietly(fis);
        }
        return this.findMatch(bytes);
    }

    public ContentInfo findMatch(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[this.fileReadSize];
        int numRead = inputStream.read(bytes);
        if (numRead < 0) {
            return null;
        }
        if (numRead < bytes.length) {
            bytes = Arrays.copyOf(bytes, numRead);
        }
        return this.findMatch(bytes);
    }

    public ContentInfo findMatch(byte[] bytes) {
        return this.magicEntries.findMatch(bytes);
    }

    public static ContentInfo findExtensionMatch(String name) {
        ContentType type = ContentType.fromFileExtension(name = name.toLowerCase());
        if (type != ContentType.OTHER) {
            return new ContentInfo(type);
        }
        int index = name.lastIndexOf(46);
        if (index < 0 || index == name.length() - 1) {
            return null;
        }
        type = ContentType.fromFileExtension(name.substring(index + 1));
        if (type == ContentType.OTHER) {
            return null;
        }
        return new ContentInfo(type);
    }

    public static ContentInfo findMimeTypeMatch(String mimeType) {
        ContentType type = ContentType.fromMimeType(mimeType.toLowerCase());
        if (type == ContentType.OTHER) {
            return null;
        }
        return new ContentInfo(type);
    }

    public void setFileReadSize(int fileReadSize) {
        this.fileReadSize = fileReadSize;
    }

    public void setErrorCallBack(ErrorCallBack errorCallBack) {
        this.errorCallBack = errorCallBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MagicEntries readEntriesFromFile(File fileOrDirectory) throws FileNotFoundException, IOException {
        if (fileOrDirectory.isFile()) {
            FileReader reader = new FileReader(fileOrDirectory);
            try {
                MagicEntries magicEntries = this.readEntries(reader);
                return magicEntries;
            }
            finally {
                this.closeQuietly(reader);
            }
        }
        if (fileOrDirectory.isDirectory()) {
            MagicEntries entries = new MagicEntries();
            for (File subFile : fileOrDirectory.listFiles()) {
                FileReader fr = new FileReader(subFile);
                try {
                    this.readEntries(entries, fr);
                }
                catch (IOException e) {
                }
                finally {
                    this.closeQuietly(fr);
                }
            }
            entries.optimizeFirstBytes();
            return entries;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MagicEntries readEntriesFromResource(String resource) throws IOException {
        InputStream stream = this.getClass().getResourceAsStream(resource);
        if (stream == null) {
            return null;
        }
        InputStreamReader reader = null;
        try {
            reader = resource.endsWith(".gz") ? new InputStreamReader(new GZIPInputStream(new BufferedInputStream(stream))) : new InputStreamReader(new BufferedInputStream(stream));
            stream = null;
            MagicEntries magicEntries = this.readEntries(reader);
            this.closeQuietly(reader);
            this.closeQuietly(stream);
            return magicEntries;
        }
        catch (Throwable throwable) {
            this.closeQuietly(reader);
            this.closeQuietly(stream);
            throw throwable;
        }
    }

    private MagicEntries readEntries(Reader reader) throws IOException {
        MagicEntries entries = new MagicEntries();
        this.readEntries(entries, reader);
        entries.optimizeFirstBytes();
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEntries(MagicEntries entries, Reader reader) throws IOException {
        BufferedReader lineReader = new BufferedReader(reader);
        try {
            entries.readEntries(lineReader, this.errorCallBack);
        }
        finally {
            this.closeQuietly(lineReader);
        }
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static interface ErrorCallBack {
        public void error(String var1, String var2, Exception var3);
    }
}

