/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.servlets.login;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.openexchange.exception.OXException;
import com.openexchange.guard.servlets.AbstractGuardServlet;
import com.openexchange.guard.servlets.GuardServletAction;
import com.openexchange.guard.servlets.authentication.GuardAuthenticationHandler;
import com.openexchange.guard.servlets.authentication.OXGuardSessionAuthenticationHandler;

/**
 * Provides login and authentication functionality for OX Guard
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public class LoginServlet extends AbstractGuardServlet {

    private static final long serialVersionUID = -1451153388216107948L;
    private static final String LOGOUT_ACTION = "logout";
    private static final String RESET_PASSWORD_ACTION = "reset";
    private static final String GET_SECONDARY_EMAIL_ACTION = "secondary";
    private static final String LOGIN_ACTION = "login";
    private static final String LOGIN_GUEST_ACTION = "guest";
    private static final String CHANGE_PASSWORD_ACTION = "changepass";
    private static final String CREATE_KEYS_ACTION = "create";
    private static final String CHANGE_SECONDARY_EMAIL_ACTION = "changesecondary";
    private static final String DELETE_RECOVERY_ACTION = "deleterecovery";
    private static final String DELETE_SESSION = "delete_session";

    private transient final HashMap<String, GuardServletAction> servletGetActions;
    private transient final HashMap<String, GuardServletAction> servletPostActions;
    private transient final HashMap<String, GuardServletAction> servletPutActions;

    public LoginServlet(GuardAuthenticationHandler basicAuthServletAuthentication ) throws OXException {

        OXGuardSessionAuthenticationHandler uiSessionAuthentication = new OXGuardSessionAuthenticationHandler();

        //GET
        servletGetActions = new HashMap<String, GuardServletAction>();
        servletGetActions.put(LOGOUT_ACTION, new LogoutAction().setAuthenticationHandler(uiSessionAuthentication));
        servletGetActions.put(RESET_PASSWORD_ACTION, new ResetPasswordAction().setAuthenticationHandler(uiSessionAuthentication));
        servletGetActions.put(GET_SECONDARY_EMAIL_ACTION, new GetSecondaryEmailAction().setAuthenticationHandler(uiSessionAuthentication));

        //POST
        servletPostActions = new HashMap<String, GuardServletAction>();
        servletPostActions.put(LOGIN_ACTION, new LoginAction().setAuthenticationHandler(uiSessionAuthentication));
        servletPostActions.put(LOGIN_GUEST_ACTION, new LoginGuestAction());
        servletPostActions.put(CHANGE_PASSWORD_ACTION, new ChangePasswordAction().setAuthenticationHandler(uiSessionAuthentication));
        servletPostActions.put(CREATE_KEYS_ACTION, new CreateKeysActions().setAuthenticationHandler(uiSessionAuthentication));
        servletPostActions.put(CHANGE_SECONDARY_EMAIL_ACTION, new ChangeSecondaryEmailAction().setAuthenticationHandler(uiSessionAuthentication));
        servletPostActions.put(DELETE_RECOVERY_ACTION, new DeleteRecoveryAction().setAuthenticationHandler(uiSessionAuthentication));

        //PUT
        servletPutActions = new HashMap<String, GuardServletAction>();
        if (basicAuthServletAuthentication != null) {
            servletPutActions.put(DELETE_SESSION, new DeleteSesssionAction().setAuthenticationHandler(basicAuthServletAuthentication));
        }
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        doAction(request, response, servletGetActions);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        doAction(request, response, servletPostActions);
    }

    @Override
    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        doAction(request, response, servletPutActions);
    }
}
