/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.pgp.exceptions;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.exception.OXExceptionStrings;

/**
 *
 * {@link GuardPGPExceptionCodes}
 *
 * @author <a href="mailto:martin.schneider@open-xchange.com">Martin Schneider</a>
 * @since v2.4.0
 */
public enum GuardPGPExceptionCodes implements DisplayableOXExceptionCode {

    /** Unable to retrieve sender keys. */
    SENDER_KEYS_MISSING("Unable to retrieve sender keys.", GuardPGPExceptionMessages.SENDER_KEYS_MISSING_MSG, CATEGORY_ERROR, 1),

    SEND_FAILED("Sending email failed: %1$s",GuardPGPExceptionMessages.SEND_FAILED_MSG, CATEGORY_ERROR, 2),

    ENCODING_NOT_SUPPORTED("The provided encoding is not supported.",GuardPGPExceptionMessages.ENCODING_NOT_SUPPORTED_MSG, CATEGORY_ERROR, 3),

    MAIL_CONSTRUCTION_ERROR("Error while creating the encrypted mail.",GuardPGPExceptionMessages.MAIL_CONSTRUCTION_ERROR_MSG, CATEGORY_ERROR, 4),

    BAD_PASSWORD_ERROR("Provided password is not correct.", GuardPGPExceptionMessages.BAD_PASSWORD_ERROR_MSG, CATEGORY_USER_INPUT, 5),

    IO_ERROR("An I/O error occurred: %1$s", GuardPGPExceptionMessages.IO_ERROR_MSG, Category.CATEGORY_ERROR, 6),

    SIGNATURE_ERROR_NO_SIGNED_DATA("No signed data found in E-Mail", GuardPGPExceptionMessages.SIGNATURE_ERROR_NO_SIGNED_DATA_MSG, Category.CATEGORY_ERROR, 7),

    SIGNATURE_ERROR_NO_SIGNATURE("No signature found in E-Mail", GuardPGPExceptionMessages.SIGNATURE_ERROR_NO_SIGNATURE_MSG, Category.CATEGORY_ERROR, 8),

    SIGNATURE_ERROR_NO_SIGNED_MESSAGE_FOUND("No signed message found in inline E-Mail", GuardPGPExceptionMessages.SIGNATURE_ERROR_NO_SIGNED_MESSAGE_FOUND_MSG, Category.CATEGORY_ERROR, 9),

    MIME_NOT_MULTIPART_ERROR("The Mime message's content is not a MultiPart content", GuardPGPExceptionMessages.MIME_NOT_MULTIPART_ERROR_MSG, Category.CATEGORY_ERROR, 10),

    MIME_NO_GUARDPART_ERROR("The MIME message does not contain an OX Guard part", GuardPGPExceptionMessages.MIME_NO_GUARDPART_ERROR_MSG, CATEGORY_ERROR, 11),

    MIME_ATTACHMENT_NOT_FOUND("No attachment found in MIME with name %1$s", GuardPGPExceptionMessages.MIME_ATTACHMENT_NOT_FOUND_MSG, CATEGORY_ERROR, 12),

    MIME_ATTACHMENT_ID_NOT_FOUND("No attachment found in MIME with id %1$s", GuardPGPExceptionMessages.MIME_ATTACHMENT_ID_NOT_FOUND_MSG, CATEGORY_ERROR, 13),

    UNEXPECTED_ERROR("An error occurred: %1$s", GuardPGPExceptionMessages.UNEXPECTED_ERROR_MSG, Category.CATEGORY_ERROR, 14),

    UNABLE_TO_DECODE("Unable to decode pgp key for user %1$s in context %2$s.", GuardPGPExceptionMessages.UNABLE_TO_DECODE_MSG, Category.CATEGORY_ERROR, 15),

    KEY_NOT_FOUND("Key with id %1$s not found", GuardPGPExceptionMessages.KEY_NOT_FOUND_MSG,Category.CATEGORY_ERROR,16),

    NO_VALID_KEY("There were no valid public keys found.  Either the keys are expired, or not flagged for this action.", GuardPGPExceptionMessages.NO_VALID_PUBLIC_KEYS_FOUND_MSG, Category.CATEGORY_ERROR, 17),

    ;

    private String message;
    private String displayMessage;
    private Category category;
    private int number;

    private GuardPGPExceptionCodes(String message, Category category, int number) {
        this(message, null, category, number);
    }

    private GuardPGPExceptionCodes(String message, String displayMessage, Category category, int number) {
        this.message = message;
        this.displayMessage = displayMessage != null ? displayMessage : OXExceptionStrings.MESSAGE;
        this.category = category;
        this.number = number;
    }

    @Override
    public String getPrefix() {
        return "GRD-PGP";
    }

    @Override
    public int getNumber() {
        return number;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public String getDisplayMessage() {
        return displayMessage;
    }

    @Override
    public Category getCategory() {
        return category;
    }

    @Override
    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals(this, e);
    }

    /**
     * Creates a new {@link OXException} instance pre-filled with this code's attributes.
     *
     * @return The newly created {@link OXException} instance
     */
    public OXException create() {
        return OXExceptionFactory.getInstance().create(this, new Object[0]);
    }

    /**
     * Creates a new {@link OXException} instance pre-filled with this code's attributes.
     *
     * @param args The message arguments in case of printf-style message
     * @return The newly created {@link OXException} instance
     */
    public OXException create(Object... args) {
        return OXExceptionFactory.getInstance().create(this, (Throwable) null, args);
    }

    /**
     * Creates a new {@link OXException} instance pre-filled with this code's attributes.
     *
     * @param cause The optional initial cause
     * @param args The message arguments in case of printf-style message
     * @return The newly created {@link OXException} instance
     */
    public OXException create(Throwable cause, Object... args) {
        return OXExceptionFactory.getInstance().create(this, cause, args);
    }
}
