/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.keymanagement.storage.impl.pgpkeys;

class PGPKeysSql {

    static final String SELECT_BY_EMAIL_STMT = "SELECT id,email,hexid, cid, local,keyid FROM PGPKeys WHERE email = ? AND cid >= 0";
    static final String SELECT_BY_HEXID_STMT = "SELECT id,email,hexid, cid, local,keyid FROM PGPKeys WHERE hexid = ?";
    static final String SELECT_BY_ID_STMT = "SELECT id,email,hexid, cid, local,keyid FROM PGPKeys WHERE id = ?";
    static final String SELECT_BY_IDS_STMT = "SELECT id, email, hexid, cid, local, keyid FROM PGPKeys WHERE id IN ({@VALUES});";
    static final String SELECT_BY_ID_IN_CONTEXT_STMT = "SELECT id,email,hexid,cid,local,keyid from PGPKeys WHERE cid = ? and id = ?";
    static final String DELETE_BY_KEYID_STMT = "DELETE FROM PGPKeys WHERE keyid = ?";
    static final String DELETE_BY_EMAIL_STMT = "DELETE FROM PGPKeys WHERE email = ?";
    static final String INSERT_OR_UPDATE_STMT = "INSERT INTO PGPKeys VALUES (?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE cid = ?";
    static final String DELETE_BY_KEYID_IN_CONTEXT_STMT = "DELETE FROM PGPKeys WHERE cid = ? and keyid = ?";
    static final String UPDATE_CONTEXT_ID_BY_KEY_ID_STMT = "UPDATE PGPKeys set cid = ? where keyid = ?";
    static final String UPDATE_EMAIL_ADDRESS = "UPDATE PGPKeys set email = ? where email = ? and cid = ?";
}
