/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.guest;

/**
 * {@link MailUpdate}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v7.10.0
 */
public class MailUpdate {

    private static final String ALL_IDS_STR   = "ALL_MAIL_IDS";
    private String[]            mailIds       = ALL_IDS;
    private Integer             mailFlags     = null;
    private MailFlagsMode       mailFlagsMode = null;
    private Integer             colorLabel    = null;

    public enum MailFlagsMode {
        /**
         * Sets a setting
         */
        SET,

        /**
         * Removes a setting
         */
        UNSET
    }

    /**
     * Constant for updating all known E-Mails
     */
    public static final String[] ALL_IDS = new String[] { ALL_IDS_STR };

    /**
     * Gets the IDs of email items which are getting updated.
     *
     * @return The mailIds The IDs of items to update.
     */
    public String[] getMailIds() {
        return mailIds;
    }

    /**
     * Sets the IDs of the items which are getting updated.
     *
     * @param mailIds the IDs of the items to update.
     */
    public void setMailIds(String[] mailIds) {
        this.mailIds = mailIds;
    }

    /**
     * Gets the mailFlags to update
     *
     * @return The mailFlags to update
     */
    public Integer getMailFlags() {
        return mailFlags;
    }

    /**
     * Sets the mailFlags to update
     *
     * @param mailFlags The mailFlags to update
     */
    public MailUpdate setMailFlags(int mailFlags) {
        this.mailFlags = mailFlags;
        return this;
    }

    /**
     * Gets the mode
     *
     * @return The mode
     */
    public MailFlagsMode getMailFlagsMode() {
        return mailFlagsMode;
    }

    /**
     * Sets the update mode
     *
     * @param mode The new update mode to set
     */
    public MailUpdate setMailFlagsMode(MailFlagsMode mode) {
        this.mailFlagsMode = mode;
        return this;
    }

    /**
     * Gets the color label
     *
     * @return The new color label
     */
    public Integer getColorLabel() {
        return this.colorLabel;
    }

    /**
     * Sets the new color label
     *
     * @param colorLabel The new color label
     * @return this
     */
    public MailUpdate setColorLabel(Integer colorLabel) {
        this.colorLabel = colorLabel;
        return this;
    }
}
