/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.database.exception;

import com.openexchange.i18n.LocalizableStrings;

/**
 * {@link GuardDatabaseExceptionMessages}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v7.10.0
 */
public class GuardDatabaseExceptionMessages  implements LocalizableStrings {

    // Technical error.  Unlikely to be displayed
    public static final String MISSING_PRIVILEGES_ERROR_MSG = "Open-Xchange server is unable to create the new database \"%1$s\" for user \"%2$s\" due to missing privileges. Add required privileges to the mysql user for the given database and start again.";
    // Unexpected database error followed by error message
    public static final String DB_ERROR_MSG = "Unexpected database error: \"%1$s\"";
    // Technical error
    public static final String DB_REGISTER_ERROR_MSG = "Unable to register new database \"%1$s\"";
    // Technical error. Unable to retrieve a database connection
    public static final String CONNECTION_RETRIEVAL_ERROR_MSG = "Unable to retrieve a database connection to url '%1$s'. Please check configured database host, user and password.";
    // Technical error.  No database assigned for the schema named %1
    public static final String ASSIGNMENT_NOT_AVAILABLE_FOR_SCHEMA_MSG = "No database assignment available for the schema with name '%1$s'";
    // Administrative error. The Guest does not have a database shard assigned
    public static final String GUEST_NOT_ASSIGNED_TO_SHARD_MSG = "Guest with email address '%1$s' is not assigned to a shard.";
    // Administrative error.  The guest with the userid and context does not have a database shard assigned
    public static final String GUEST_WITH_IDS_NOT_ASSIGNED_TO_SHARD_MSG = "Guest with user id '%1$s' in context '%2$s' is not assigned to a shard.";

    private GuardDatabaseExceptionMessages() {}
}
