/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.configuration;

import com.openexchange.exception.OXException;
import com.openexchange.guard.configuration.osgi.Services;

/**
 * {@link GuardProductName}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public class GuardProductName {

    /**
     * Gets the configured product name
     * 
     * @param host the host to the get the host specific product name for
     * @return the configured product name for the given host
     * @throws OXException
     */
    public static String getProductName(String host) throws OXException {
        return getProductName(host, 0, 0);
    }

    /**
     * Gets the configured product name
     * 
     * @param host the host to the get the host specific product name for
     * @param cid the context id of the user to get the product name for
     * @param userid the id of the user to get the product name for
     * @return the configured product name for the given host
     * @throws OXException
     */
    public static String getProductName(String host, int cid, int userid) throws OXException {
        GuardConfigurationService configuartionService = Services.getService(GuardConfigurationService.class);
        String name = null;
        if (host != null && !host.isEmpty()) {
            if (cid < 0) {  // Guest account, no cascade settings here.
                userid = -1;
                cid = -1;
            }
            name = configuartionService.getServerConfiguration(host, userid, cid, "guard.productName");
        }
        if (name == null) {
            if (cid > 0) {
                return (configuartionService.getProperty(GuardProperty.productName, userid, cid));
            } else {
                return (configuartionService.getProperty(GuardProperty.productName));
            }
        }
        return name;
    }
}
