define([
    'spec/shared/capabilities',
    'spec/shared/waitsFor',
    'io.ox/core/extensions'
], function (caputil, waitsFor, ext) {

    var capabilities = caputil.preset('common').init();

    describe('Mailvelope integration', function () {
        var mailvelopeAPI = {};

        beforeEach(function () {
            window.mailvelope = mailvelopeAPI;
            return $.when(require(['settings!oxguard']), capabilities.enable('mailvelope')).then(function (settings) {
                settings.set('cryptoProvider', 'mailvelope');
                return require([
                    'mailvelope/main',
                    'mailvelope/settings/pane',
                    'oxguard/settings/pane'
                ]);
            });
        });
        afterEach(function () {
            //manually remove handler, or it will be triggered multiple times
            $(window).off('mailvelope');
            delete window.mailvelope;
            require.undef('mailvelope/main');
        });

        describe('provides settings extension', function () {
            var nameStub, emailStub;
            beforeEach(function () {
                var api = require('io.ox/core/api/account');
                nameStub = sinon.stub(api, 'getDefaultDisplayName', function () { return 'Jan Doe'; });
                emailStub = sinon.stub(api, 'getPrimaryAddress', function () { return $.when(['Jan Doe', 'jan.doe@example.com']); });
            });
            afterEach(function () {
                nameStub.restore();
                emailStub.restore();
            });

            it('should register "oxguard/settings/detail" extension point', function () {
                var hasExtension = ext.point('oxguard/settings/detail').has('oxguardsettings');
                expect(hasExtension, 'extension exists').to.be.true;
            });

            it('should paint the mailvelope settings pane', function () {
                var $el = $('<div id="settingsPanes" class="scrollable-pane">');
                mailvelopeAPI.createSettingsContainer = _.noop;
                mailvelopeAPI.getKeyring = function (id) {
                    return $.when({
                        id: id,
                        exportOwnPublicKey: function () {
                            return $.when('---BEGIN PGP PUBLIC KEY---');
                        }
                    });
                };
                ext.point('oxguard/settings/detail').invoke('draw', $el);
                return waitsFor(function () {
                    return $el.find('.mailvelope-settings-pane').length > 0;
                }).then(function () {
                    expect($el.find('div').hasClass('mailvelope-settings-pane abs'), 'find mailvelope-settings-pane class').to.be.true;
                    expect($el.find('div').hasClass('scrollable-pane'), 'find scrollable-pane class').to.be.false;
                });
            });

            it('should call the mailvelope API to render the mailvelope settings', function () {
                var $el = $('<div id="settingsPanes">');
                var painted = $.Deferred();
                mailvelopeAPI.createSettingsContainer = _.noop;
                mailvelopeAPI.getKeyring = function (id) {
                    return $.when({
                        id: id,
                        exportOwnPublicKey: function () {
                            return $.when('---BEGIN PGP PUBLIC KEY---');
                        }
                    });
                };
                var stub = sinon.stub(mailvelopeAPI, 'createSettingsContainer', function (selector, keyring, options) {
                    expect(selector).to.equal('.mailvelope-settings-pane');
                    expect(keyring.id).to.equal('jan.doe');
                    expect(options.email).to.equal('jan.doe@example.com');
                    expect(options.fullName).to.equal('Jan Doe');
                    painted.resolve();
                });
                ext.point('oxguard/settings/detail').invoke('draw', $el);
                return painted.then(function () {
                    expect(stub.calledOnce, 'createSettingsContainer called once').to.be.true;
                    stub.restore();
                });
            });
        });
    });
});
