/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

describe('Mail', function () {

    describe('Send To New User', function () {

        it('Compose secure email to new user', function (client) {

            // First, wipe the 3rd test user's Guard account
            client.wipeUser(2);

            // Log into the recipient account
            client
            .login('app=io.ox/mail', { 'userIndex': 2 } )
            .waitForElementVisible('.io-ox-mail-window .window-body .classic-toolbar a[data-action="compose"]', 20000);

            // Wipe the inbox
            client
            .selectFolder({ id: 'default0/INBOX' })
            .openFolderContextMenu({ id: 'default0/INBOX' })
            .clickWhenVisible('.dropdown.open a[data-action="markfolderread"]')
            .openFolderContextMenu({ id: 'default0/INBOX' })
            .clickWhenVisible('.dropdown.open a[data-action="clearfolder"]')
            .clickWhenVisible('.btn[data-action="delete"]');

            // Logout of the user
            client.logout(false);

            client
            .login('app=io.ox/mail')
            .waitForElementVisible('.io-ox-mail-window .window-body .classic-toolbar a[data-action="compose"]', 20000);

            client.verifyEnabled();

            // 1) Login to mail app
            client
                .clickWhenVisible('.launchers li[data-app-name="io.ox/mail"]')
                .assert.containsText('*[data-app-name="io.ox/mail"]', 'Mail');

            // 3) Open mail compose
            client.waitForElementVisible('.io-ox-mail-window .window-body .classic-toolbar a[data-action="compose"]', 20000)
                .assert.containsText('.io-ox-mail-window .window-body .classic-toolbar a[data-action="compose"]', 'Compose')
                .clickWhenEventListener('.io-ox-mail-window .window-body  .classic-toolbar a[data-action="compose"]', 'click', 2500)
                .waitForElementVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor', 20000)
                .pause(1000)
                .assert.title('App Suite. Compose');

            // 4) Select "Encrypt" as text format under "Options"
            client
                .clickWhenVisible('.io-ox-mail-compose div[data-extension-id="composetoolbar-menu"] .dropdown.security-options', 2000)
                .clickWhenVisible('.dropdown.open a[data-name="encrypt"]', 2000)
                .waitForElementVisible('.fa.fa-2x.encrypted', 20000);

            // 5) Set a recipient, add a subject and mail text
            client
                .insertMailaddress('.io-ox-mail-compose div[data-extension-id="to"] input.tt-input', 2)
                .setValue('.io-ox-mail-compose div[data-extension-id="subject"] input', 'Test subject')
                .setValue('.io-ox-mail-compose-window .editor .editable', 'Test text');

            // 6) Send the E-Mail and check it as recipient
            client
                .click('.io-ox-mail-compose-window .window-footer button[data-action="send"]');

            client.pause(1000);

            client.logout(false);

            client
            .login('app=io.ox/mail', { 'userIndex': 2 } )
            .waitForElementVisible('.io-ox-mail-window .leftside ul li.unread', 20000)
            .click('.io-ox-mail-window .leftside ul li.unread');

            client
            .waitForElementVisible('input[name="newogpassword"]', 1000)
            .insertPassword('input[name="newogpassword"]', 2)
            .assert.visible('.oxguard_hint_warn')
            .insertPassword('input[name="newogpassword2"]', 2)
            .click('.btn[data-action="okpass"]')
            .waitForElementVisible('.btn[data-action="done"]', 2000)
            .click('.btn[data-action="done"]');

            // 8 Verify decrypted
            client
            .waitForElementVisible('.io-ox-mail-window .mail-detail-pane .subject', 1000)
            .assert.containsText('.io-ox-mail-window .mail-detail-pane .subject', 'Test subject')
            .shadowWaitForElementVisible('.io-ox-mail-window .mail-detail-pane .body::shadow .mail-detail-content', 2500)
            .assert.shadowContainsText('.io-ox-mail-window .mail-detail-pane .body::shadow .mail-detail-content', 'Test text');

            client.logout();
        });

    });

});