/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Settings');

Scenario('First Setup and tour', function* (I) {
    // First, wipe the user
    I.wipeUser(1);
    // Next, log in to settings
    I.login(['app=io.ox/settings', 'folder=virtual/settings/oxguard'], { 'userIndex': 1 });
    I.waitForElement('.io-ox-guard-settings');
    I.waitForElement('.guard-start-button');

    // Click the setup button and verify wizard;
    I.click('.guard-start-button');
    I.waitForElement('.btn.btn-primary[data-action="next"]');
    I.see('Start Setup');

    // Click Start
    I.click('.btn.btn-primary[data-action="next"]');
    I.waitForElement('.wizard-content .guard-create-key');
    I.see('Please enter a password');

    // Try mismatched password and verify error
    I.insertCryptPassword('#newogpassword', 1);
    I.fillField('#newogpassword2', 'mismatch');
    I.wait(1);
    I.see('Passwords not equal');
    expect(yield I.grabAttributeFrom('.btn.btn-primary[data-action="next"]', 'disabled')).to.equal('true');


    // Correct password and verify error gone
    I.insertCryptPassword('#newogpassword2', 1);
    I.wait(1);
    expect(yield I.grabAttributeFrom('.btn.btn-primary[data-action="next"]', 'disabled')).to.equal(null);  // Verify next button no longer disabled
    I.fillField('input[name="recoverymail"]', 'test@email.com');
    I.wait(1);
    I.click('.btn.btn-primary[data-action="next"]');

    // Verify complete shown, and start tour
    I.waitForElement('#startTourLink');
    I.see('Guided tour');
    I.click('#startTourLink');

    // Make sure tour is set for non-advanced
    I.setSetting('oxguard', 'advanced', false);

    I.waitForElement('.contenteditable-editor');
    I.waitForElement('.hotspot');
    I.see('Security and privacy');
    I.click('.btn.btn-primary[data-action="next"]');

    // Verify Seucrity Settings opened, and password management illustrated
    I.waitForElement('.io-ox-guard-settings');
    I.waitForElement('.wizard-content');
    I.see('You already set up');
    I.waitForElement('.wizard-overlay.wizard-spotlight.abs'); // Highlighted area
    I.click('.btn.btn-primary[data-action="next"]');

    // Begin illustrating Defaults
    I.waitForElement('.hotspot');
    I.waitForElement('.wizard-overlay.wizard-spotlight.abs');
    I.see('From here');
    I.click('.btn.btn-primary[data-action="next"]');

    // Default signing
    I.waitForElement('.hotspot');
    I.see('In addition to encrypting');
    I.click('.btn.btn-primary[data-action="next"]');

    // Advanced options
    I.waitForElement('.hotspot');
    I.see('Advanced User Settings');
    I.click('.btn.btn-primary[data-action="next"]');

    // Opens up compose again to show unlock
    I.waitForElement('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor');
    I.waitForElement('.hotspot');
    I.see('Enabling and disabling');
    I.click('.btn.btn-primary[data-action="next"]');

    // Show file encryption
    I.waitForElement('.io-ox-files-main .window-sidepanel');
    I.waitForElement('.wizard-title');
    I.see('Encrypt files');
    I.click('.btn.btn-primary[data-action="next"]');

    // Show option to restart tour
    I.waitForElement('[data-name="GuardTour"]');
    I.waitForElement('.hotspot');
    I.see('Restart Guided Tour');
    I.click('.btn.btn-primary[data-action="next"]');

    // Show done
    I.waitForElement('.btn.btn-primary[data-action="done"]');
    I.click('.btn.btn-primary[data-action="done"]');

    // Done
    I.logout();
    
});