/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Send Encrypted To Self');

Scenario('Compose and receive encrypted email', function (I) {

    // Log in as User 0
    I.login('app=io.ox/mail');
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');

    I.verifyUserSetup(0);  // Verify user has Guard setup

    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Mark inbox as all read
    I.selectFolder('Inbox');
    I.waitForVisible('.selected .contextmenu-control');
    I.click('.selected .contextmenu-control');
    I.click('.dropdown.open a[data-action="markfolderread"]');

    // Open compose
    I.sendEmail(0, subject, data, 'testFiles/ox.png');

    I.waitForVisible('.io-ox-mail-window .leftside');
    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');
    I.waitForVisible('.io-ox-mail-window .mail-detail-pane .subject');
    I.see(subject);

    // Decrypt
    I.waitForElement('.btn.oxguard_passbutton');
    I.waitForElement('input.form-control.password_prompt');
    I.insertCryptPassword('input.form-control.password_prompt', 0);
    I.click('.btn.oxguard_passbutton');

    I.verifyDecryptedMail(subject, data);

    // Verify Attachment
    I.waitForVisible('a[data-ref="io.ox/mail/actions/view-attachment"]');
    I.click('a[data-ref="io.ox/mail/actions/view-attachment"]');

    // Verify password prompt
    I.waitForVisible('#ogPassword');
    I.insertCryptPassword('#ogPassword', 0);
    I.click('.btn-primary[data-action="ok"]');

    // Verify attachment viewable
    I.waitForVisible('.swiper-slide-active .viewer-displayer-item.viewer-displayer-image');

    // Close it
    I.click('a.viewer-toolbar-close');
    I.waitForVisible('.io-ox-mail-window .leftside');

    // OK, done
    I.logout();

});
