/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Send Encrypted To New Guard User');

Scenario('Compose and receive encrypted email', function (I) {
    // First, wipe the recipient user
    I.wipeUser(1);
    
    // Next, log in as the second user to clean up inbox
    I.login('app=io.ox/mail', { 'userIndex': 1 });
    I.wipeInbox();
    // Logout, and log back in as the sender
    I.logout();

    I.login('app=io.ox/mail');
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');

    // Test data
    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Open compose
    I.sendEmail(1, subject, data);

    I.wait(2);

    // Logout and log back in as second user
    I.logout();
    I.login('app=io.ox/mail', { 'userIndex': 1 });
    I.waitForVisible('.io-ox-mail-window .leftside');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    // Change temporary password
    I.changeTemporaryPassword(1);

    I.waitForVisible('.btn[data-action="done"]');  // Wizard shows done
    I.click('.btn[data-action="done"]');

    // Verify decrypted
    I.verifyDecryptedMail(subject, data);

    // OK, done
    I.logout();
});