/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Send Encrypted To Guest');

Scenario('Compose and receive encrypted email', function (I) {

    // Wipe the Guest user
    I.wipeUser(3);

    I.login('app=io.ox/mail', { 'userIndex': 3 });
    I.wipeInbox(3);
    I.logout();

    // Log in as User 0
    I.login('app=io.ox/mail');
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');

    I.verifyUserSetup(0);  // Verify user has Guard setup

    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Compose email to Guest
    I.sendEmailGuest(3, subject, data);

    I.logout();

    // Login to retrieve guest invite email
    I.login('app=io.ox/mail', { 'userIndex': 3 });
    I.waitForVisible('.io-ox-mail-window .leftside');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    // Click the guest link, which opens new tab
    I.clickGuestLink(subject, 'test guest introduction message');

    // Goto new tab
    I.waitAndSwitchTab();

    // Click unread email
    I.click('li.unread');
    // Change the temporary password
    I.waitForVisible('input[name="newogpassword"]');

    I.changeTemporaryPassword(3);

    // Verify email there
    I.verifyDecryptedGuestMail(subject, data);

    I.logout();



});
