const Helper = require('@open-xchange/codecept-helper').helper;

class GuardHelper extends Helper {

    verifyUserSetup (userIndex) {
        let wdio = this.helpers['WebDriverIO'],
        browser = wdio.browser,
        options = wdio.options,
        user = global.users[userIndex];

        assert(user && user.password, 'user or user password not configured for index' + userIndex);  //Check user exists

        browser.timeouts('script', 5000);
        var promise = browser.executeAsync(function (user, done) {
            if (window.oxguarddata.passcode === null) {  // already setup
                done(true);
                return;
            }
            if (window.oxguarddata.passcode === 'No Key') { // Needs setup
                require (['oxguard/core/og_http'], function (og_http) {
                    var json = {
                            name: user.username,
                            password: user.password
                        };
                    try {
                        og_http.simplePost(ox.apiRoot + '/oxguard/keys?action=create', '', json)
                        .done(function (data) {
                            if (data.error) done(data.error_desc);
                            if (data.data) {
                                window.oxguarddata.passcode = null;
                                done(true);
                            } else {
                                done('Failed to get login data');
                            }
                        })
                        .fail(function (e) {
                            done('fail post');
                        });
                    } catch (e) {
                        done(e.message);
                    }
                });
            } else {
                done('fail');  // temporary password or lockout
            }
        }, user)
        .then(function (result) {
            assert(result.value === true, result.value);
        });

        return promise;
    }

    insertPassword(selector, userIndex) {
        if (!userIndex) userIndex = 0;
        var users = this.globals.users;
        if (!users || !users.length) this.assert.fail('user not found', 'A configured user', 'Expected at least one configured user in the global array "users".');
        if (users.length < userIndex) this.assert.fail('user not found', 'A user at index ' + userIndex, 'Expected a configured user in the globals "users" array at position ' + userIndex + '.');
        var user = users[userIndex];
        if (!user.password) this.assert.fail('user without password', 'A configured password for user at index ' + userIndex, 'Expected a user with password when calling insertPassword.');
        this.clearValue(selector);
        this.setValue(selector, user.password);
    
        return this;
    }

    // Helper to switch view to tab being opened
    // Expected is new tab count after new one opens,  usually 2
    waitAndSwitchTab(expected) {
        if (!expected) expected = 2;
        let client = this.helpers['WebDriverIO'].browser;
        var promise = new Promise(function (resolve, reject) {
                client.waitUntil(function () {
                    return this.getTabIds().then(function(newTabs) {
                        if (newTabs.length == expected) {
                            client.switchTab(newTabs[expected -1]);
                            return true;
                        }
                        return false;
                    })
                }, 10000)
                .then(function () {
                    resolve();
                }, function () {
                    reject();
                });
        });
        return promise;
    }

    // Helper to upload a file to an input field
    // Selector is the input, filename should be relative to e2e directory
    uploadFile(selector, filename) {
        let wdio = this.helpers['WebDriverIO'],
        browser = wdio.browser;
        var promise = new Promise(function (resolve, reject) {
            browser.execute(function () {
                $('.io-ox-mail-compose input[type="file"]').show();
            }).then(function () {
                browser.setValue(selector, require("path").resolve(__dirname, './', filename))
                .then(resolve, reject);
            }, reject);
        });
        return promise;
    }

}
module.exports = GuardHelper;