/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/**
 * This resets a user's Guard account, referenced by userIndex
 * Changes the URL.  Will need redirect after calling (such as using the login command)
 */
const codecept = require('codeceptjs');

module.exports  = function (userIndex) {
    
        let config = codecept.config.get(),
         webDriver = config.helpers['WebDriverIO'];

        var launchURL = webDriver.url;
        if (launchURL.search('appsuite\\/?$') >= 0) launchURL = launchURL.substring(0, launchURL.search('appsuite\\/?$'));
        if (!/\/$/.test(launchURL)) launchURL += '/';
        launchURL += 'appsuite/';

        var users = global.users;
        var user = users[userIndex];
        assert(user && user.mail, "User not found");
        this.amOnPage(launchURL + 'api/oxguard/demo?action=reset&email=' + user.mail);
        this.waitForVisible('body', 2000);
    
    return this;
    
    };