/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/**
 * This sends a new email to recipient
 */

module.exports  = function (recipUserIndex, subject, data, attachment) {

       // Open compose
       this.wait(2);
       this.click('Compose');
       this.waitForVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor');
       this.wait(1);
   
       // Mark as secure
       this.click('Security');
       this.waitForVisible('.dropdown.open a[data-name="encrypt"]');
       this.click('Encrypt');
       this.waitForVisible('.fa.fa-2x.encrypted');
   
       // Verify HTML
       this.click('Options');
       this.click('HTML');
       this.waitForVisible('.io-ox-mail-compose-window .editor .editable');
   
       // Insert test data
       this.insertMailaddress('.io-ox-mail-compose div[data-extension-id="to"] input.tt-input', recipUserIndex);  // Second user is recipient
       this.fillField('.io-ox-mail-compose [name="subject"]', subject);
       this.appendField('.io-ox-mail-compose-window .editor .editable', data);

       // Attachments if any
       if (attachment) {
           this.uploadFile('.mail-compose-fields input[type="file"]', 'testFiles/ox.png');
       }
   
       // Verify key is next to recipient names
       this.waitForVisible('i.fa.fa-key.oxguard_token.key_tooltip.trusted_key');
   
       // Send
       this.click('Send Encrypted');
       this.waitForVisible('.io-ox-mail-window .leftside');
   
};