/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 *  2016-2020 OX Software GmbH, Tarrytown, NY, USA. info@open-xchange.com
 *
 * @author Julian Baeume <julian.baeume@open-xchange.com>
 */
define('oxguard/util', [
'io.ox/core/capabilities'
], function (capabilities) {
    'use strict';

    var api = {};

    /**
     * Test if guard is configured.
     *
     * @return true if configured; false otherwise
     */
    api.isGuardConfigured = function () {
        if (window.oxguarddata === undefined) return false;
        return window.oxguarddata.passcode !== 'No Key';
    };

    api.hasSetupDone = function () {
        var def = $.Deferred();

        if (window.oxguarddata.passcode === 'No Key') {
            def.reject();
        } else def.resolve();
        if (window.oxguarddata.passcode === 'Password Needed') {
            require (['oxguard/core/tempPassword'], function (core) {
                core.createOxGuardPasswordPrompt();
            });
        }
        return (def);

    };

    api.hasCryptoCapability = function () {
        return (capabilities.has('guard'));
    };

    api.hasGuardMailCapability = function () {
        return (capabilities.has('guard-mail'));
    };

    api.isGuest = function () {
        return capabilities.has('guest');
    };

    api.isGuardLoaded = function () {
        return window.oxguarddata.loaded;
    };

    api.addOnLoaded = function (loadFunction) {
        if (!window.oxguarddata.onload) {
            window.oxguarddata.onload = [];
        }
        window.oxguarddata.onload.push(loadFunction);
    };

    return api;
});
