/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/userKeysView', [
    'io.ox/core/extensions',
    'io.ox/core/settings/util',
    'io.ox/backbone/views/modal',
    'oxguard/settings/userKeys',
    'gettext!oxguard'
    //'settings!oxguard'
], function (ext, util, ModalView, userKeys, gt) {

    'use strict';

    var POINT = 'oxguard/settings/userkeys',
        INDEX = 0;

    function open () {
        return openModalDialog();
    }

    function openModalDialog() {

        return new ModalView({
            async: true,
            point: POINT,
            title: gt('Your Keys'),
            id: 'userKeyList',
            width: 640
        })
        .inject({
            doChange: function () {
            }
        })
        .build(function () {

        })
        .addButton({ label: gt('Done'), action: 'done' })
        .on('done', function () {
            this.close();
        })
        .open();
    }

    ext.point(POINT).extend(
            // Draw Div with list keys
            {
                index: INDEX += 100,
                id: 'switch',
                render: function () {
                    var div = $('<div>');
                    this.$body.append(
                        div.append(userKeys.userKeys()).append(userKeys.localKeys())
                    );
                }
            }
            /**,
            {
                index: INDEX += 100,
                id: 'localKey',
                render: function () {
                    var div = $('<div>');
                    var checkbox = util.checkbox('pgplocal', gt('Enable local key management'), settings);
                    var node = this;
                    checkbox.on('change', function () {  // Redraw when changed
                        node.$body.empty();
                        node.invoke('render', node.$body);
                    });
                    this.$body.append(
                        div.append(checkbox)
                    );
                }
            }
            **/
     );

    return {
        open: open
    };

});
