/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/revokePrivateView', [
    'io.ox/backbone/views',
    'io.ox/core/extensions',
    'io.ox/backbone/mini-views',
    'io.ox/backbone/views/modal',
    'io.ox/core/settings/util',
    'io.ox/core/yell',
    'oxguard/core/og_http',
    'oxguard/core/passwordView',
    'oxguard/oxguard_core',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (views, ext, mini, ModalView, util, yell, http, PasswordView, core, gt) {

    'use strict';

    var POINT = 'oxguard/settings/revokePrivate',
        INDEX = 0;

    var dialog;

    function open (keyid) {
        dialog = openModalDialog(keyid);
        return dialog;
    }

    function openModalDialog(keyid) {

        return new ModalView({
            async: true,
            point: POINT,
            title: gt('Revoke Private Key'),
            width: 640,
            enter: 'cancel',
            focus: '#revokepass'
        })
        .inject({
            getRejectOptions: function () {
                return ([
                    { label: gt('No Reason'), value: 'NO_REASON' },
                    { label: gt('Key superseded'), value: 'KEY_SUPERSEDED' },
                    { label: gt('Key compromised'), value: 'KEY_COMPROMISED' },
                    { label: gt('Key retired'), value: 'KEY_RETIRED' },
                    { label: gt('User no longer valid'), value: 'USER_NO_LONGER_VALID' }
                ]);
            }
        })
        .build(function () {
        })
        .addAlternativeButton({ label: gt('Revoke'), action: 'revoke' })
        .on('revoke', function () {
            var dialog = this;
            doRevoke(keyid).done(function () {
                dialog.close();
                $('#refreshuserkeys').click();
            })
            .fail(function (e) {
                dialog.idle();
                if (e && e.length > 1) yell('error', e);
            });
        })
        .addButton()
        .open();
    }

    ext.point(POINT).extend(
            {
                index: INDEX += 100,
                id: 'header',
                render: function () {
                    var label = $('<label>').append(gt('This will advise people not to use this key.  You can still use the key to decode existing items.'))
                    .append('<br>');
                    this.$body.append(
                        label
                    );
                }
            },
            {
                index: INDEX += 100,
                id: 'getPassword',
                render: function () {
                    var label = $('<label for="revokepass">').append(
                            gt('Please enter your %s password', window.oxguarddata.productName))
                    .append('<br>');
                    var password = new PasswordView.view({ 'id': 'revokepass' }).getProtected();
                    this.$body.append(
                        label.append(password)
                    );
                }
            },
            {
                index: INDEX += 100,
                id: 'delete',
                render: function () {
                    var dropdown = util.compactSelect('revokereason', gt('Revocation reason'), new Backbone.Model(), this.getRejectOptions(), { 'integer': 1 });
                    dropdown.val('NO_REASON');
                    this.$body.append(
                        dropdown
                    );
                }
            }

     );

    function doRevoke (keyid) {
        var def = $.Deferred();
        var pass = $('#revokepass').val();
        var reason = $('#settings-revokereason').val();
        if (pass.length > 1) {
            var json = {
                keyid: keyid,
                reason: reason,
                password: pass
            };
            var params = '&keyid=' + keyid;
            core.metrics('settings', 'revoke-private-key');
            http.simplePost(ox.apiRoot + '/oxguard/keys?action=revoke', params, json)
            .done (function (data) {
                if (core.checkJsonOK(data)) {
                    yell('success', gt('Key Revoked'));
                    def.resolve();
                } else {
                    def.reject();
                }
            })
            .fail (function (e) {
                def.reject(gt('Failed to revoke key'));
                console.log(e);
            });
            return def;
        } else {
            def.reject(gt('Problem revoking key'));
        }
        return def;
    }

    return {
        open: open
    };

});
