/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/publicKeysView', [
    'io.ox/backbone/views',
    'io.ox/core/extensions',
    'io.ox/backbone/mini-views',
    'io.ox/backbone/views/modal',
    'io.ox/core/settings/util',
    'io.ox/core/yell',
    'oxguard/pgp/keyDetails',
    'oxguard/core/og_http',
    'oxguard/oxguard_core',
    'gettext!oxguard'
], function (views, ext, mini, ModalView, util, yell, pubkeys, og_http, core, gt) {

    'use strict';

    var POINT = 'oxguard/settings/pubkeys',
        INDEX = 0;

    function open () {
        return openModalDialog();
    }

    function openModalDialog() {

        return new ModalView({
            async: true,
            point: POINT,
            title: gt('Public Keys'),
            id: 'pkeyList',
            width: 640
        })
        .inject({
            doChange: function () {
            }
        })
        .build(function () {

        })
        .addButton({ label: gt('Done'), action: 'done' })
        .on('done', function () {
            this.close();
        })
        .open();
    }

    ext.point(POINT).extend(
            // Draw Div with list keys
            {
                index: INDEX += 100,
                id: 'switch',
                render: function () {
                    var div = $('<div>');
                    this.$body.append(
                        div.append(pubkeys.listPublic('settings'))
                    );
                }
            }
     );

    return {
        open: open
    };

});
