/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/deleteRecoveryView', [
    'io.ox/backbone/views',
    'io.ox/core/extensions',
    'io.ox/backbone/mini-views',
    'io.ox/backbone/views/modal',
    'io.ox/core/settings/util',
    'io.ox/core/yell',
    'oxguard/core/og_http',
    'oxguard/oxguard_core',
    'gettext!oxguard'
], function (views, ext, mini, ModalView, util, yell, og_http, core, gt) {

    'use strict';

    var POINT = 'oxguard/settings/reset',
        INDEX = 0;

    function open (node, baton) {
        return openModalDialog(node, baton);
    }

    function openModalDialog(node, baton) {

        return new ModalView({
            async: true,
            focus: 'input[name="active"]',
            point: POINT,
            title: gt('Delete Recovery'),
            width: 640
        })
        .inject({
        })
        .build(function () {
        })
        .addCancelButton()
        .addButton({ label: gt('Delete'), action: 'delete' })
        .on('delete', function () {
            this.close();
            performDelete().done(function () {
                ext.point('oxguard/settings/detail').invoke('draw', node, baton);  // redraw settings
            }).fail(this.idle).fail(yell);
        })
        .open();
    }

    ext.point(POINT).extend(
            {
                index: INDEX += 100,
                id: 'switch',
                render: function () {
                    this.$body.append(
                        $('<p>').append(gt('The password recovery is used to reset your password if you forget it.  If you delete the recovery, you will not be able to reset your password.')),
                        $('<p>').append(gt('Note: Changing your password will restore the password recovery.'))
                    );
                }
            }
     );

    function performDelete() {
        var def = $.Deferred();
        core.getPassword(gt('Please verify your password before deleting the recovery.'))
        .done (function (e) {
            var data = {
                userid: ox.user_id,
                cid: ox.context_id,
                password: e.password
            };
            core.metrics('settings', 'delete-recovery');
            og_http.post(ox.apiRoot + '/oxguard/login?action=deleterecovery', '', data)
            .done (function () {
                yell('success', gt('Recovery deleted'));
                window.oxguarddata.recovery = false;
                def.resolve();
            })
            .fail (function (e) {
                if (e.responseText.trim() === 'Bad password') {
                    yell('error', gt('Bad Password'));
                } else {
                    yell('error', e.responseText);
                }
                def.reject();
            });
        })
        .fail(function () {
            def.reject();
        });
        return def;
    }

    return {
        open: open
    };

});
