/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/deletePrivateViewStep2', [
    'io.ox/backbone/views',
    'io.ox/core/extensions',
    'io.ox/backbone/mini-views',
    'io.ox/backbone/views/modal',
    'io.ox/core/settings/util',
    'io.ox/core/yell',
    'oxguard/core/og_http',
    'oxguard/core/passwordView',
    'oxguard/oxguard_core',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (views, ext, mini, ModalView, util, yell, http, PasswordView, core, gt) {

    'use strict';

    var POINT = 'oxguard/settings/deletePrivateStep2',
        INDEX = 0;

    var dialog;

    function open (keyid) {
        dialog = openModalDialog(keyid);
        return dialog;
    }

    function openModalDialog(keyid) {

        return new ModalView({
            async: true,
            point: POINT,
            title: gt('Delete Private Key'),
            width: 640,
            focus: '#deletepass'
        })
        .inject({
        })
        .build(function () {
        })
        .addAlternativeButton({ label: gt('Delete'), action: 'delete' })
        .on('delete', function () {
            var dialog = this;
            doDelete(keyid).done(function () {
                dialog.close();
                $('#refreshuserkeys').click();
            })
            .fail(function (e) {
                dialog.idle();
                if (e && e.length > 1) yell('error', e);
            });
        })
        .addButton()
        .open();
    }

    ext.point(POINT).extend(
            {
                index: INDEX += 100,
                id: 'header',
                render: function () {
                    var label = $('<label style="color:red">').append(gt('You will no longer be able to decode any items that were encrypted with this key!'))
                    .append('<br>');
                    this.$body.append(
                        label
                    );
                }
            },
            {
                index: INDEX += 100,
                id: 'getPassword',
                render: function () {
                    var label = $('<label for="deletepass">').append(
                            gt('Please enter your %s password', window.oxguarddata.productName))
                    .append('<br>');
                    var password = new PasswordView.view({ 'id': 'deletepass' }).getProtected();
                    this.$body.append(
                        label.append(password)
                    );
                }
            }

     );

    function doDelete (keyid) {
        var def = $.Deferred();
        var pass = $('#deletepass').val();
        if (pass.length > 1) {
            var json = {
                password: pass
            };
            var params = '&keyid=' + keyid;
            core.metrics('settings', 'delete-private-key');
            http.simplePost(ox.apiRoot + '/oxguard/keys?action=delete', params, json)
            .done (function (data) {
                if (core.checkJsonOK(data)) {
                    def.resolve();
                } else {
                    def.reject();
                }
            })
            .fail (function (e) {
                def.reject(gt('Failed to delete key'));
                console.log(e);
            });
            return def;
        } else {
            def.reject();
        }
        def.reject(gt('Problem deleting key'));
        return def;
    }

    /*
    function checkTempPassword (auth) {
        if (auth.indexOf('Password Needed') > -1) {
            require (['oxguard/core/tempPassword'], function (core) {
                core.createOxGuardPasswordPrompt();
            });
        }
    }
    */

    return {
        open: open
    };

});
