/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/deletePrivateView', [
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'oxguard/oxguard_core',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (ext, ModalView, core, gt) {

    'use strict';

    var POINT = 'oxguard/settings/deletePrivate',
        INDEX = 0;

    var dialog;

    function open (keyid, master) {
        var isMaster = master === 'true';
        dialog = openModalDialog(keyid, isMaster);
        return dialog;
    }

    function openModalDialog(keyid, isMaster) {

        var dialog = new ModalView({
            async: true,
            point: POINT,
            model: new Backbone.Model({ 'isMaster': isMaster }),
            title: window.oxguarddata.settings.noDeletePrivate || !isMaster ? gt('Revoke Private Key') : gt('Delete Private Key'),
            width: 640,
            enter: 'cancel'
        })
        .inject({
        })
        .build(function () {
        });
        if (!window.oxguarddata.settings.noDeletePrivate && isMaster) {
            dialog.addAlternativeButton({ label: gt('Delete'), action: 'delete' });
        }
        dialog
        .addAlternativeButton({ label: gt('Revoke'), action: 'revoke' })
        .on('delete', function () {
            this.close();
            ox.load(['oxguard/settings/views/deletePrivateViewStep2']).then(function (view) {
                view.open(keyid);
            });
        })
        .on('revoke', function () {
            this.close();
            ox.load(['oxguard/settings/views/revokePrivateView']).then(function (revoke) {
                revoke.open(keyid);
            });
        })
        .addButton()
        .open();
        return dialog;
    }

    ext.point(POINT).extend(
            {
                index: INDEX += 100,
                id: 'header',
                render: function (baton) {
                    if (window.oxguarddata.settings.noDeletePrivate || !baton.model.get('isMaster')) return;
                    var label = $('<label>').append(gt('There are two options if you no longer want to use this key'))
                    .append('<br>');
                    this.$body.append(
                        label
                    );
                }
            },
            {
                index: INDEX += 100,
                id: 'revoke',
                render: function () {
                    var label = $('<label for="uploadPublicButton">').append(
                            gt('Revoke the key: This advises others that you no longer want this key used.  You can continue to decode any encrypted data using the key. (Recommended)'))
                    .append('<br>');
                    this.$body.append(
                        label
                    );
                }
            },
            {
                index: INDEX += 100,
                id: 'delete',
                render: function (baton) {
                    if (window.oxguarddata.settings.noDeletePrivate || !baton.model.get('isMaster')) return;
                    var label = $('<label for="createNewButton">').append(
                            gt('Deleting the key: Deleting the private key will render all encrypted items unreadable.  You will not be able to decode emails or files that were enrypted with this key.  This will delete this key and any sub-keys. This cannot be undone.'))
                    .append('<br>');
                    this.$body.append(
                        label
                    );
                }
            }

     );

    return {
        open: open
    };

});
