/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/mail/pin', [
    'io.ox/core/tk/dialogs',
    'oxguard/mail/keymanager',
    'oxguard/mail/mail_metrics',
    'gettext!oxguard',
    'less!oxguard/mail/style'
], function (dialogs, keyman, metrics, gt) {
    function showpin (baton) {
        var def = $.Deferred();
        var pin = getpin();
        var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter: 'ok' });
        dialog.header($('<h4>').text(gt('Advanced Security - PIN')));
        var message = $('<p>');
        var tableMessage = $('<p style="float:left;">' + gt('Recipients:') + '</p>');
        var table = $('<textarea cols="40" rows="3" style="float:right; padding:5px; margin-right:5%; max-width:90%;"/>');
        var names = '';
        (keyman.getGuests(baton)).forEach(function (v) {
            names = names  + v + '\r\n';
        });
        table.text(names);
        message.append(gt('The new recipients listed below will be sent instructions how to read this email.  For additional security, you can assign a PIN that will be used for additional verification.'));
        var pinlabel = $('<label class="pin">' + pin + '</label>');
        var message2 = $('<p>').append(gt('You may deliver this pin any way you see fit, but we recommend doing it in a second method other than email (Phone, SMS, Skype, etc).'));
        var message3 = $('<p>').append(gt('If you forget this pin, you can find it in the sent email (requires decrypting).'));
        dialog.getBody().append(message).append(pinlabel).append(message2).append(message3).append('<hr/>').append(tableMessage).append(table);
        dialog.addPrimaryButton('ok', gt('Use PIN'), 'ok')
        .addButton('cancel', gt('Skip'), 'cancel')
        .on('ok', function () {
            metrics.track ('guest-pin-added');
            def.resolve(pin);
        })
        .on('cancel', function () {
            metrics.track ('guard-pin-skipped');
            def.reject();
        }).show();
        return (def);
    }

    function getpin () {
        var length = 4;
        var num = Math.floor((Math.random() * (Math.pow(10, length))) + 1);
        return (pad(num, length));
    }

    function pad(n, width) {
        n = n.toString();
        return n.length >= width ? n : new Array(width - n.length + 1).join('0') + n;
    }

    return {
        showpin: showpin
    };
});
