/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */

define('oxguard/files/downloader', [
], function () {
    // Open file in viewer

    function viewFile(baton, action, auth)
    {
        var file_options = { params: {
                cryptoAction: 'Decrypt',
                cryptoAuth: auth,
                session: encodeURIComponent(ox.session)
            } };
        var selection = [].concat(baton.data);
        baton.collection.models.map(function (file) {
            if (file.get('filename') && (/(\.pgp)$/i.test(file.get('filename')) || (file.get('source') === 'guard') || (file.get('meta') && (file.get('meta').Encrypted === true)))) {// Make sure OxGuard file
                file.set('file_options', file_options);
                file.set('source', 'guardDrive');
            }
        });
        ox.load(['io.ox/core/viewer/main']).done(function (Viewer) {
            var viewer = new Viewer();
            if (selection.length > 1) {
                // only show selected files - the first one is automatically selected
                viewer.launch({ files: selection });
            } else {
                viewer.launch({ selection: _(selection).first(), files: baton.collection.models });
            }
        });
    }

    return {
        viewFile: viewFile
    };
});
