/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/core/og_http', [
], function () {
    'use strict';

    function doPost (url, params, data, json) {
        var def = $.Deferred();
        params = params + '&session=' + ox.session;
        if (data === null || data === undefined) data = {};
        var t0 = _.now();
        $.ajax({
            url: url + params,
            type:'POST',
            dataType: json ? 'json' : 'text',
            data: (json ? JSON.stringify(data) : data),
            contentType: (json ? 'application/json; charset=utf-8;' : 'application/x-www-form-urlencoded'),
            success: function (rdata) {
                if (!json && rdata && rdata.indexOf('{') === 0) {  // If json response instead of text, parse the json
                    rdata = JSON.parse(rdata);
                }
                def.resolve (rdata);
                if ((_.now() - t0) > 1000) {
                    require (['oxguard/core/log'], function (log) {
                        log.slow ((_.now() - t0), url, params, data);
                    });
                }
            }
        })
        .fail (function (r) {
            require (['oxguard/core/log'], function (log) {
                log.fail(r, url, params, data);
            });
            def.reject(r);
        });
        return (def);
    }

    function doPut (url, params, data) {
        var def = $.Deferred();
        params = params + '&session=' + ox.session;
        if (data === null || data === undefined) data = {};
        var t0 = _.now();
        $.ajax({
            url: url + params,
            type:'PUT',
            data: JSON.stringify(data),
            dataType: 'json',
            contentType:'application/json; charset=utf-8',
            success: function (rdata) {
                def.resolve (rdata);
                if ((_.now() - t0) > 1000) {
                    require (['oxguard/core/log'], function (log) {
                        log.slow ((_.now() - t0), url, params, data);
                    });
                }
            }
        })
        .fail (function (r) {
            require (['oxguard/core/log'], function (log) {
                log.fail(r, url, params, data);
            });
            def.reject(r);
        });
        return (def);
    }

    // Post JSON data
    function post (url, params, data) {
        return postAction (url, params, data, true);
    }

    // Post using x-www-form-urlencoded
    function simplePost (url, params, data) {
        return postAction (url, params, data, false);
    }

    // Look for passwords in outgoing data.  If able, encrypt
    function postAction (url, params, data, json) {
        var def = $.Deferred();
        require (['oxguard/crypto/encr'], function (encr) {
            if (window.oxguarddata && window.oxguarddata.pubKey !== undefined && data !== undefined) {
                if (data.password !== undefined) {
                    if (data.password !== '') {
                        var epass = encr.cryptPass(data.password);
                        if (epass !== null) {
                            data.e_password = epass;
                            delete data.password;
                        }
                    }
                }
                if (data.encr_password !== undefined) {
                    if (data.encr_password !== '') {
                        var encrpass = encr.cryptPass(data.encr_password);
                        if (encrpass !== null) {
                            data.e_encr_password = encrpass;
                            delete data.encr_password;
                        }
                    }
                }
                if (data.extrapass !== undefined) {
                    if (data.extrapass !== '') {
                        var expass = encr.cryptPass(data.extrapass);
                        if (expass !== null) {
                            data.e_extrapass = expass;
                            delete data.extrapass;
                        }
                    }
                }
            }
            doPost (url, params, data, json)
            .done (function (e) {
                def.resolve(e);
            })
            .fail (function (f) {
                def.reject(f);
            });
        });
        return (def);
    }

    function get (url, params) {
        var def = $.Deferred();
        var t0 = _.now();
        params = params + '&session=' + ox.session + '&ticks=' + t0;
        $.get(url + params, function (rdata) {
            def.resolve(rdata);
            if ((_.now() - t0) > 1000) {
                require (['oxguard/core/log'], function (log) {
                    log.slow ((_.now() - t0), url, params, {});
                });
            }
        })
        .fail (function (r) {
            if (r.status === 200) {
                try {
                    var data = JSON.parse(r.responseText);
                    def.resolve(data);
                } catch (e) {
                    console.log(e);
                    def.reject(r);
                }
            }
            require (['oxguard/core/log'], function (log) {
                log.fail(r, url, params, {});
            });
            def.reject(r);
        });

        return (def);
    }

    return {
        post: post,
        simplePost: simplePost,
        get: get,
        put: doPut
    };
});
