/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/core/confirmView', [
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'oxguard/oxguard_core',
    'io.ox/core/yell',
    'oxguard/core/og_http',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (ext, ModalView, core, yell, http, gt) {

    'use strict';

    var POINT = 'oxguard/core/confirmView',
        INDEX = 0;

    function open (prompt) {
        var def = $.Deferred();
        openModalDialog(prompt, def);
        return def;
    }

    function openModalDialog(prompt, def) {

        return new ModalView({
            async: true,
            point: POINT,
            title: gt('Confirmation Required'),
            width: 400,
            model: new Backbone.Model({ 'prompt': prompt })
        })
        .inject({
        })
        .build(function () {
        })
        .addAlternativeButton({ label: gt('Confirm'), action: 'confirm' })
        .on('confirm', function () {
            this.close();
            def.resolve();
        })
        .on('cancel', function () {
            def.reject();
        })
        .addButton()
        .open();
    }

    ext.point(POINT).extend(
            {
                index: INDEX += 100,
                id: 'header',
                render: function (baton) {
                    var label = $('<label>').append(baton.model.get('prompt'))
                    .append('<br>');
                    this.$body.append(
                        label
                    );
                }
            }

     );

    return {
        open: open
    };

});
