/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/contacts/register_contacts', [
    'io.ox/core/extensions',
    'oxguard/pgp/keyDetails',
    'settings!oxguard',
    'less!oxguard/style'
], function (ext, pubkeys, settings) {

    ext.point('io.ox/contacts/detail').extend({
        id: 'pgppublic',
        index: 'last',
        draw: function (baton) {
            //FIXME: this completely disables the point for apps other than settings and contacts (like mail called from sidepanel)
            if (!(baton.app && baton.app.cid)) return;
            if (!settings.get('advanced')) return;  //advanced view only
            if (baton.data && baton.data.distribution_list) return;  // Not listing for distribution lists
            //var list = (baton.data.email1 ? baton.data.email1 : '') + (baton.data.email2 ? (',' + baton.data.email2) : '') + (baton.data.email3 ? (',' + baton.data.email3) : '');
            var newfield = $('<fieldset class="block" data-block="pgp">');
            var location = $(this).find('article.clearfix');
            if (location[0] !== undefined) {
                $(location[0]).append(newfield.append(pubkeys.listPublic(baton.app.cid, baton.data.folder_id, baton.data.id)));
            }

        }
    });
});
