/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.support;

import com.openexchange.exception.OXException;
import com.openexchange.guard.email.storage.ogEmail.EmailStorage;
import com.openexchange.guard.keymanagement.commons.GuardKeys;
import com.openexchange.guard.keymanagement.services.GuardKeyService;
import com.openexchange.guard.keymanagement.storage.KeyTableStorage;
import com.openexchange.guard.keymanagement.storage.PGPKeysStorage;
import com.openexchange.guard.osgi.Services;
import com.openexchange.guard.ratifier.GuardRatifierService;

/**
 * {@link UserChanger}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.0
 */
public class UserChanger {

    private static org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(UserChanger.class);

    public void changeUser (String email, String newEmail) throws OXException {
        GuardKeyService keyService = Services.getService(GuardKeyService.class);
        GuardKeys keys = keyService.getKeys(email);
        if (keys == null) {
            throw OXException.general("Unable to find user specified by " + email);
        }
        if (newEmail != null) {
            // Change primary email address
            updateEmailAddress (keys, newEmail);
        }
    }

    public void changeUser (int userId, int contextId, String newEmail) throws OXException {
        GuardKeyService keyService = Services.getService(GuardKeyService.class);
        GuardKeys keys = keyService.getKeys(userId, contextId);
        if (keys == null) {
            logger.info("Unable to find any Guard user by Id = " + userId + " in context " + contextId);
            return;
        }
        if (newEmail != null) {
            // Change primary email address
            updateEmailAddress (keys, newEmail);
        }
    }

    public void updateEmailAddress (GuardKeys key, String newEmail) throws OXException {
        GuardRatifierService ratifier = Services.getService(GuardRatifierService.class);
        ratifier.validate(newEmail);
        if (newEmail.contains("%")) { // One last sanity check
            throw OXException.general("Invalid email address " + newEmail);
        }
        // Update user og_KeyTable
        KeyTableStorage keyStorage = Services.getService(KeyTableStorage.class);
        keyStorage.updateEmailAddress(key, newEmail);
        // Update the og_email lookup table
        EmailStorage emailStorage = Services.getService(EmailStorage.class);
        emailStorage.updateEmail(key.getEmail(), newEmail);
        // Update PGP Key lookup table
        PGPKeysStorage pgpKeyStorage = Services.getService(PGPKeysStorage.class);
        pgpKeyStorage.changeEmailAddress(key.getEmail(), newEmail, key.getContextid());

    }
}
