/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.servlets.guest;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.openexchange.exception.OXException;
import com.openexchange.guard.servlets.AbstractGuardServlet;
import com.openexchange.guard.servlets.GuardServletAction;
import com.openexchange.guard.servlets.authentication.BasicAuthServletAuthenticationHandler;
import com.openexchange.guard.servlets.authentication.OXGuardSessionAuthenticationHandler;

/**
 * Provides functionality for guest accounts
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public class GuestServlet extends AbstractGuardServlet {

    private static final long serialVersionUID = 845555040236787927L;

    private static final String GET_PASSWORD_RESET_QUESTION = "getquestion";
    private static final String GET_RESET_PASSWORD_ACTION = "resetpassword";
    private static final String GET_RESET_ACCOUNT = "resetaccount";
    private static final String POST_DO_RESET = "doresetaccount";
    private static final String POST_FIRST_PASS = "firstpass";

    //new guest actions since 7.8.10
    private static final String GET_MESSAGE ="getmessage";
    private static final String GET_MESSAGES ="getmessages";
    private static final String GET_MESSAGE_LIST ="getmessagelist";
    private static final String UPDATE_MESSAGES = "updatemessages";
    private static final String MOVE_MESSAGES = "movemessages";
    private static final String COPY_MESSAGES = "copymessages";
    private static final String DELETE_MESSAGES = "deletemessages";
    private static final String APPEND_MESSAGE = "appendmessage";
    private static final String UPGRADE_GUEST = "convertGuest";

    private final HashMap<String, GuardServletAction> getActions;
    private final HashMap<String, GuardServletAction> postActions;

    /**
     * Initializes a new {@link GuestServlet}.
     * @throws OXException
     */
    public GuestServlet() throws OXException {
        OXGuardSessionAuthenticationHandler uiSessionAuthentication = new OXGuardSessionAuthenticationHandler();
        BasicAuthServletAuthenticationHandler basicAuthAuthentication = createBasicAuthHandler();

        //GET
        getActions = new HashMap<String, GuardServletAction>();

        //No session required for getting the reset password question and for resetting the password
        getActions.put(GET_PASSWORD_RESET_QUESTION, new GetPasswordResetQuestion());
        getActions.put(GET_RESET_PASSWORD_ACTION, new ResetPasswordAction());
        getActions.put(GET_RESET_ACCOUNT, new ResetGuardAccountAction());

        //POST
        postActions = new HashMap<String, GuardServletAction>();
       postActions.put(POST_DO_RESET, new DoResetGuardAccount());
        postActions.put(POST_FIRST_PASS, new GuestFirstPasswordAction());
        //new guest actions since 7.10
        postActions.put(GET_MESSAGE, new GetMessage().setAuthenticationHandler(basicAuthAuthentication));
        postActions.put(GET_MESSAGE_LIST, new GetMessageList().setAuthenticationHandler(basicAuthAuthentication));
        postActions.put(GET_MESSAGES, new GetMessages().setAuthenticationHandler(basicAuthAuthentication));
        postActions.put(UPDATE_MESSAGES, new UpdateMessages().setAuthenticationHandler(basicAuthAuthentication));
        postActions.put(MOVE_MESSAGES, new MoveMessages().setAuthenticationHandler(basicAuthAuthentication));
        postActions.put(COPY_MESSAGES, new CopyMessages().setAuthenticationHandler(basicAuthAuthentication));
        postActions.put(DELETE_MESSAGES, new DeleteMessages().setAuthenticationHandler(basicAuthAuthentication));
        postActions.put(APPEND_MESSAGE, new AppendMessage().setAuthenticationHandler(basicAuthAuthentication));
        postActions.put(UPGRADE_GUEST, new GuestUpgrader().setAuthenticationHandler(uiSessionAuthentication));
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        doAction(request, response, getActions);
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doAction(request, response, postActions);
    }
}
