/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.pgp.signing.impl;

import java.util.ArrayList;
import java.util.List;
import com.openexchange.guard.pgp.signing.EmailSignatureVerificationResult;
import com.openexchange.pgp.core.PGPSignatureVerificationResult;

/**
 * {@link SignatureResults}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.8.0
 */
public class SignatureResults {

    private static final String VERIFIED_PROPERTY = "verified";
    private static final String DATE_PROPERTY = "signatureCreatedOn";
    private static final String MISSING_PROPERTY = "missing";


    public static String[] toHeaders (List<PGPSignatureVerificationResult> results) {
        List stringResults = new ArrayList();
        for(PGPSignatureVerificationResult result : results) {
            stringResults.add(toHeader(result));
        }
        String [] res = new String[stringResults.size()];
        return (String[]) stringResults.toArray(res);
    }

    public static String toHeader (PGPSignatureVerificationResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append(VERIFIED_PROPERTY + "=");
        sb.append(result.isVerified() ? "true" : "false");
        sb.append("; " + MISSING_PROPERTY + "=");
        sb.append(result.isMissing() ? "true" : "false");
        sb.append("; " + DATE_PROPERTY + "=");
        sb.append(result.getSignature().getCreationTime().getTime());
        return sb.toString();
    }

    public static String toHeader (EmailSignatureVerificationResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append(VERIFIED_PROPERTY + "=");
        sb.append(result.isVerified() ? "true" : "false");
        sb.append("; " + MISSING_PROPERTY + "=");
        sb.append(result.isMissingPublicKey() ? "true" : "false");
        return sb.toString();
    }
}
