/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.wks.servlets;

import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.exception.OXException;
import com.openexchange.guard.common.servlets.utils.ServletUtils;
import com.openexchange.guard.inputvalidation.RegexInputValidator;

/**
 *
 * Provides basic WKS (WebKey Service) servlet
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.0
 */
public class WksServlet extends HttpServlet {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 1376745436525L;
    private static final Logger logger = LoggerFactory.getLogger(WksServlet.class);

    private void verifyHash (String hash) throws OXException {
        new RegexInputValidator("[a-z0-9]{32}").assertInput(hash);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {

        logger.debug("Webkey Service request " + request.getPathInfo());
        String hash = request.getPathInfo().replace("/", "");
        try {
            verifyHash (hash);
        } catch (OXException e) {
            logger.error("Bad search string for webkey service", e);
            return;
        }
        try {
            WksGetAction action = new WksGetAction(response, hash, request.getServerName());
            action.doAction();
        } catch (OXException | IOException ex) {
            logger.error("Problem handling WebKey request ", ex);
        }
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            //OX Guard does not support/allow key uploads via HKP
            //To be RFC compliant we send a 501-not implemented
            logger.debug("Hu post not implemented");
            ServletUtils.sendAnswer(response, HttpServletResponse.SC_NOT_IMPLEMENTED, "WKS post not supported");
        } catch (IOException e) {
            logger.error("Unexpected error while handling WKS request", e);
            ServletUtils.sendError(response, e);
        }
    }
}
