/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.oxapi.pooling.internal;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.configuration.GuardConfigurationService;
import com.openexchange.guard.configuration.GuardProperty;
import com.openexchange.guard.oxapi.osgi.Services;

public class IdleConnectionMonitor extends Thread {

    private static Logger LOG = LoggerFactory.getLogger(IdleConnectionMonitor.class);

    private final HttpClientConnectionManager connMgr;
    private final ConnPoolControl<HttpRoute> poolControl;
    private volatile boolean shutdown;
    private int lastcount = 0;
    private final String name;

    public IdleConnectionMonitor(HttpClientConnectionManager connMgr, ConnPoolControl<HttpRoute> poolControl, String name) {
        super();
        this.connMgr = connMgr;
        this.poolControl = poolControl;
        this.name = name;
    }

    @Override
    public void run() {
        try {
            while (!shutdown) {
                synchronized (this) {
                    wait(2000);
                    getStats();
                    connMgr.closeExpiredConnections();
                    connMgr.closeIdleConnections(Services.getService(GuardConfigurationService.class).getIntProperty(GuardProperty.oxBackendIdleTime), TimeUnit.SECONDS);
                }
            }
        } catch (InterruptedException ex) {
            shutdown();
        } catch (Exception e) {
            LOG.debug("Error in idle monitor loop", e);
        }
    }

    public void shutdown() {
        shutdown = true;
        synchronized (this) {
            notifyAll();
        }
    }

    private void getStats() {
        PoolStats stats =  poolControl.getTotalStats();
        int total = stats.getAvailable() + stats.getLeased();
        if (total != lastcount) {
            LOG.debug("HTTP " + name + " pool connections- In Pool: " + stats.getAvailable() + " Active: " + stats.getLeased() + " Hold: " + stats.getPending());
        }
        lastcount = total;
    }

}
