/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.milter.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import com.openexchange.guard.keymanagement.commons.RecipKey;
import com.openexchange.guard.milter.service.MilterMail;

/**
 * {@link GuardMilterMail}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.8.0
 */
public class GuardMilterMail implements MilterMail {

    private ArrayList<String> rcpts;

    private ArrayList <RecipKey> keys;

    private HashMap<String, String> headers;

    private byte[] body;

    private boolean willHandle = true;

    public GuardMilterMail () {
        this.rcpts = new ArrayList<String>();
        this.headers = new HashMap<String, String>();
        this.keys = new ArrayList<RecipKey>();
        this.body = null;
        this.willHandle = true;
    }

    @Override
    public void addRcpt (String rcpt) {
        rcpts.add(rcpt);
    }

    @Override
    public void addHeader (String header, String value) {
        this.headers.put(header, value);
    }

    @Override
    public void addBody (byte[] body) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (this.body != null) out.write(this.body);  // Concat to existing body data
        out.write(body);
        this.body = out.toByteArray();
    }

    @Override
    public ArrayList<String> getRcpts () {
        return rcpts;
    }

    @Override
    public String getHeader (String header) {
        return this.headers.get(header);
    }

    @Override
    public String getBody () {
        return this.body == null ? null : new String(this.body);
    }

    @Override
    public byte[] getBodyBytes () {
        return this.body;
    }

    @Override
    public boolean willHandle() {
        return this.willHandle;
    }

    @Override
    public void addRecipientKey(RecipKey key) {
        keys.add(key);
    }

    /*
     * Get list of recipient Keys
     */
    @Override
    public ArrayList<RecipKey> getKeys() {
        return keys;
    }

    @Override
    public void setHandle(boolean toHandle) {
        this.willHandle = toHandle;

    }

}
