/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.logger;

import com.j256.simplemagic.logger.LocalLog;
import com.j256.simplemagic.logger.Log;
import com.j256.simplemagic.logger.Logger;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerFactory {
    public static final String LOG_TYPE_SYSTEM_PROPERTY = "com.j256.simplemagic.logger.type";
    private static LogType logType;

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String className) {
        if (logType == null) {
            logType = LoggerFactory.findLogType();
        }
        return new Logger(logType.createLog(className));
    }

    public static String getSimpleClassName(String className) {
        String[] parts = className.split("\\.");
        if (parts.length <= 1) {
            return className;
        }
        return parts[parts.length - 1];
    }

    private static LogType findLogType() {
        String logTypeString = System.getProperty(LOG_TYPE_SYSTEM_PROPERTY);
        if (logTypeString != null) {
            try {
                return LogType.valueOf(logTypeString);
            }
            catch (IllegalArgumentException e) {
                LocalLog log = new LocalLog(LoggerFactory.class.getName());
                log.log(Log.Level.WARNING, "Could not find valid log-type from system property 'com.j256.simplemagic.logger.type', value '" + logTypeString + "'");
            }
        }
        for (LogType logType : LogType.values()) {
            if (!logType.isAvailable()) continue;
            return logType;
        }
        return LogType.LOCAL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LogType {
        LOCAL(LocalLog.class.getName(), LocalLog.class.getName()){

            public Log createLog(String classLabel) {
                return new LocalLog(classLabel);
            }

            public boolean isAvailable() {
                return true;
            }
        };

        private final String detectClassName;
        private final String logClassName;

        private LogType(String detectClassName, String logClassName) {
            this.detectClassName = detectClassName;
            this.logClassName = logClassName;
        }

        public Log createLog(String classLabel) {
            try {
                return this.createLogFromClassName(classLabel);
            }
            catch (Exception e) {
                LocalLog log = new LocalLog(classLabel);
                log.log(Log.Level.WARNING, "Unable to call constructor with single String argument for class " + this.logClassName + ", so had to use local log: " + e.getMessage());
                return log;
            }
        }

        public boolean isAvailable() {
            if (!this.isAvailableTestClass()) {
                return false;
            }
            try {
                Log log = this.createLogFromClassName(((Object)((Object)this)).getClass().getName());
                log.isLevelEnabled(Log.Level.INFO);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        Log createLogFromClassName(String classLabel) throws Exception {
            Class<?> clazz = Class.forName(this.logClassName);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return (Log)constructor.newInstance(classLabel);
        }

        boolean isAvailableTestClass() {
            try {
                Class.forName(this.detectClassName);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

