/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.entries;

import com.j256.simplemagic.ContentInfo;
import com.j256.simplemagic.ContentInfoUtil;
import com.j256.simplemagic.entries.MagicEntry;
import com.j256.simplemagic.entries.MagicEntryParser;
import com.j256.simplemagic.logger.Logger;
import com.j256.simplemagic.logger.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;

public class MagicEntries {
    private static final int MAX_LEVELS = 20;
    private static final int FIRST_BYTE_LINKED_LIST_SIZE = 256;
    private static Logger logger = LoggerFactory.getLogger(MagicEntries.class);
    private MagicEntry entryLinkedList;
    private final MagicEntry[] firstByteLinkedLists = new MagicEntry[256];
    private MagicEntry[] levelNexts = new MagicEntry[20];

    public void readEntries(BufferedReader lineReader, ContentInfoUtil.ErrorCallBack errorCallBack) throws IOException {
        String line;
        MagicEntry previousEntry = null;
        while ((line = lineReader.readLine()) != null) {
            MagicEntry entry;
            block14: {
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                try {
                    entry = MagicEntryParser.parseLine(previousEntry, line, errorCallBack);
                    if (entry == null) {
                    }
                    break block14;
                }
                catch (IllegalArgumentException e) {
                    if (errorCallBack == null) continue;
                    errorCallBack.error(line, e.getMessage(), e);
                }
                continue;
            }
            int level = entry.getLevel();
            if (previousEntry == null) {
                if (level != 0) {
                    if (errorCallBack == null) continue;
                    errorCallBack.error(line, "first entry of the file but the level (" + level + ") should be 0", null);
                    continue;
                }
            } else {
                for (int levelCount = level + 1; levelCount <= previousEntry.getLevel(); ++levelCount) {
                    this.levelNexts[levelCount] = null;
                }
            }
            if (this.levelNexts[level] == null) {
                if (level == 0) {
                    this.entryLinkedList = entry;
                } else if (this.levelNexts[level - 1] != null) {
                    this.levelNexts[level - 1].setChild(entry);
                }
            } else {
                this.levelNexts[level].setNext(entry);
            }
            this.levelNexts[level] = entry;
            previousEntry = entry;
        }
        for (int levelCount = 1; levelCount < this.levelNexts.length; ++levelCount) {
            this.levelNexts[levelCount] = null;
        }
    }

    public void optimizeFirstBytes() {
        this.levelNexts = null;
        MagicEntry[] firstByteNexts = new MagicEntry[this.firstByteLinkedLists.length];
        MagicEntry previousNonFirstByteEntry = null;
        MagicEntry entry = this.entryLinkedList;
        while (entry != null) {
            byte[] startingBytes = entry.getStartsWithByte();
            if (startingBytes == null || startingBytes.length == 0) {
                if (previousNonFirstByteEntry == null) {
                    this.entryLinkedList = entry;
                } else {
                    previousNonFirstByteEntry.setNext(entry);
                }
                previousNonFirstByteEntry = entry;
            } else {
                int index = 0xFF & startingBytes[0];
                if (firstByteNexts[index] == null) {
                    this.firstByteLinkedLists[index] = entry;
                } else {
                    firstByteNexts[index].setNext(entry);
                }
                firstByteNexts[index] = entry;
            }
            MagicEntry next = entry.getNext();
            entry.setNext(null);
            entry = next;
        }
    }

    public ContentInfo findMatch(byte[] bytes) {
        ContentInfo info;
        if (bytes.length == 0) {
            return null;
        }
        int index = 0xFF & bytes[0];
        if (index < this.firstByteLinkedLists.length && this.firstByteLinkedLists[index] != null && (info = this.findMatch(bytes, this.firstByteLinkedLists[index])) != null) {
            return info;
        }
        return this.findMatch(bytes, this.entryLinkedList);
    }

    private ContentInfo findMatch(byte[] bytes, MagicEntry entryLinkedList) {
        ContentInfo partialMatchInfo = null;
        for (MagicEntry entry = entryLinkedList; entry != null; entry = entry.getNext()) {
            ContentInfo info = entry.matchBytes(bytes);
            if (info == null) continue;
            if (!info.isPartial()) {
                logger.trace("found full match {}", entry);
                logger.trace("returning full match {}", info);
                return info;
            }
            if (partialMatchInfo != null) continue;
            logger.trace("found partial match {}", entry);
            partialMatchInfo = info;
        }
        if (partialMatchInfo == null) {
            logger.trace("returning no match");
            return null;
        }
        logger.trace("returning partial match {}", partialMatchInfo);
        return partialMatchInfo;
    }
}

