/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.projectset.data;

import com.openexchange.projectset.data.Repository;
import com.openexchange.projectset.data.RepositoryType;
import org.apache.tools.ant.BuildException;

public class CVSRepository
extends Repository {
    private final String cvsRoot;
    private final String repositoryLocation;
    private final String branch;

    public CVSRepository(String cvsRoot, String repositoryLocation, String projectName) {
        this(cvsRoot, repositoryLocation, projectName, "HEAD");
    }

    public CVSRepository(String cvsRoot, String repositoryLocation, String projectName, String branch) {
        super(projectName);
        this.cvsRoot = cvsRoot;
        this.repositoryLocation = repositoryLocation;
        this.branch = branch;
    }

    @Override
    public RepositoryType getRepositoryType() {
        return RepositoryType.CVS;
    }

    public String getCvsRoot() {
        return this.cvsRoot;
    }

    public String getRepositoryLocation() {
        return this.repositoryLocation;
    }

    public String getBranch() {
        return this.branch;
    }

    static CVSRepository parseCVSReference(String reference) {
        CVSRepository retval;
        String[] parts = reference.split(",");
        if (!"1.0".equals(parts[0])) {
            throw new BuildException("Unknown CVS reference version " + parts[0]);
        }
        switch (parts.length) {
            case 4: {
                retval = new CVSRepository(parts[1], parts[2], parts[3]);
                break;
            }
            case 5: {
                retval = new CVSRepository(parts[1], parts[2], parts[3], parts[4]);
                break;
            }
            default: {
                throw new BuildException("Unknown number of CVS reference definition parts.");
            }
        }
        return retval;
    }
}

