

package com.openexchange.guard.pgp;

import java.io.ByteArrayInputStream;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMultipart;
import com.openexchange.exception.OXException;
import com.openexchange.guard.mime.helpfiles.HelpFileService;
import com.openexchange.guard.osgi.Services;
import com.openexchange.pgp.mail.tools.PGPMimeMailCreator;


public class GuardPGPMimeMailCreator {

    private final HelpFileService helpFileService;

    /**
     * Initializes a new {@link GuardPGPMimeMailCreator}.
     *
     * @throws OXException
     */
    public GuardPGPMimeMailCreator() throws OXException {
        this.helpFileService = Services.getService(HelpFileService.class);
    }

    public MimeMultipart createPGPMime(final byte[] data, final String... languages) throws Exception {
        List<BodyPart> additionalClearTextFiles = null;
        if(languages != null) {
            additionalClearTextFiles = helpFileService.getHelpFiles(languages);
        }
        return new PGPMimeMailCreator().createPGPMimePart(new ByteArrayInputStream(data), additionalClearTextFiles);
    }

}
