
package com.openexchange.guard.oxapi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.openexchange.exception.OXException;
import com.openexchange.guard.exceptions.GuardCoreExceptionCodes;
import com.openexchange.guard.oxapi.exceptions.OXApiExceptionCodes;
import com.openexchange.guard.oxapi.osgi.Services;
import com.openexchange.guard.oxapi.pooling.HttpConnectionPoolService;

/**
 *
 * {@link SessionInformation} - Client access for com.openexchange.rest.services.session.SessionRESTService
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public class SessionInformation extends AbstractOXCalls {

    private static final String SESSION_REST_PATH = "/preliminary/session/v1/get/";
    private static final String MIME_JSON = "application/json";

    private JsonObject getJson(String url) throws OXException {

        HttpConnectionPoolService poolService = Services.getService(HttpConnectionPoolService.class);
        HttpClient http = poolService.getClient();
        HttpGet get = new HttpGet(url);
        get.addHeader("accept", MIME_JSON);
        get.setHeader("User-Agent", Api.USER_AGENT);
        get.addHeader(getAuthenticationHeader());
        HttpResponse response = null;
        try {
            response = http.execute(get);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"))) {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == HttpServletResponse.SC_OK) {
                    JsonParser parser = new JsonParser();
                    return parser.parse(reader).getAsJsonObject();
                }
                else {
                    throw OXApiExceptionCodes.WRONG_ERROR_CODE.create(statusCode);
                }
            }
        } catch (IOException e) {
            throw GuardCoreExceptionCodes.IO_ERROR.create(e, e.getMessage());
        } finally {
            get.releaseConnection();
        }
    }

    private String getUrl(String sessionId) throws OXException {
        return getMainURI() + SESSION_REST_PATH + sessionId;
    }

    public JsonObject getSessionInformation(String sessionId) throws OXException {
        return getJson(getUrl(sessionId));
    }
}
