package com.openexchange.guard.keymanagement.services;

import com.openexchange.exception.OXException;
import com.openexchange.guard.keymanagement.commons.GuardKeys;

public interface PasswordChangeService {

    /**
     *
     * @param userid
     * @param cid
     * @param email
     * @param oldpass
     * @param newpass
     * @param question
     * @param answer
     * @param sessionId
     * @return
     * @throws OXException
     */
    public String changePassword (int userid, int cid, String userEmail, String oldpass, String newpass, String question, String answer, String pin, String sessionId) throws OXException;

    /**
     * Changes the key password and generates new {@link GuardKeys}
     *
     * @param oldPass The old password
     * @param newPass The new password
     * @param oldKey The old key
     * @return The new {@link GuardKeys}
     * @throws OXException
     */
    GuardKeys changePassword(String oldPass, String newPass, GuardKeys oldKey) throws OXException;

    /**
     * Changes the key password and generates a new {@link GuardKeys}
     *
     * @param oldPassHash The old hashed password
     * @param newPass The new password (unhashed)
     * @param oldKey The old key
     * @return The new {@link GuardKeys}
     * @throws OXException
     */
    GuardKeys changePasswordWithRecovery(String oldPassHash, String newPass, GuardKeys oldKey) throws OXException;

    /**
     * Changes the temporary password of a key.  Key must never have been updated.
     * Will return new keys, but will not update database
     * @param userid
     * @param cid
     * @param password
     * @return
     * @throws OXException
     */
    GuardKeys changeTemporaryPassword (int userid, int cid, String password) throws OXException;
}
