/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.guest.impl.comparators;

import java.util.Comparator;
import com.openexchange.guard.guest.GuardGuestEmail;

/**
 * {@link GuardGuestEmailComparator} abstract class for comparing instances of {@link GuardGuestEmail}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v7.10.0
 */
public abstract class GuardGuestEmailComparator implements Comparator<GuardGuestEmail> {

    /**
     * Checks if one of the given argument is null
     *
     * @param arg0 The first argument
     * @param arg1 The second argument
     * @return True if arg0 or arg1 is null, false if both are not null
     */
    protected boolean checkForNull(Object arg0, Object arg1) {
        return arg0 == null || arg1 == null;
    }

    /**
     * Compares two objects assuming that one or both of the given arguments are null
     *
     * @param arg0 The first argument
     * @param arg1 The second argument
     * @return 0 if both arguments are null, 1 if the first argument is null, -1 if the second argument is null.
     */
    protected int compareNull(Object arg0, Object arg1) {
        if (arg0 == null && arg1 == null) {
            return 0;
        }

        if (arg0 == null) {
            return 1;
        }

        return -1;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
     */
    @Override
    public int compare(GuardGuestEmail arg0, GuardGuestEmail arg1) {
        if (checkForNull(arg0, arg1)) {
            return compareNull(arg0, arg1);
        }
        return compareEmails(arg0, arg1);
    }

    /**
     * Compares two instances of {@link GuardGuestEmail}
     * <br>
     * <br>
     * Implementations can safely assume that none of the given arguments are <code>null</code>
     *
     * @param arg0 A E-Mail
     * @param arg1 Another E-Mail
     * @return A negative integer, zero, or a positive integer as the first argument is less than, equal to, or greater than the second.
     * @see Comparator#compare(Object, Object)
     */
    public abstract int compareEmails(GuardGuestEmail arg0, GuardGuestEmail arg1);
}
