/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.database;

import com.openexchange.exception.OXException;

/**
 * {@link GuardShardingService}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public interface GuardShardingService {

    /**
     * Get the next shard number. If there is no next shard a new one will be created. The implementation should lock the tables to ensure an atomic operation
     *
     * @return the next shard number
     * @throws OXExcption
     */
    int getNextShard() throws OXException;

    /**
     * Checks if a shard exists for the given userid and contextid
     * @param userId the user ID
     * @param cid the context ID
     * @return True, if a shard exists for the given IDs, false otherwise
     * @throws OXException
     */
    boolean hasShard(int userId, int cid) throws OXException;

    /**
     * Get the shard for the specified user identifier for the specified context
     *
     * @param userId The user identifier
     * @param cid The context identifier
     * @return the shard identifier
     * @throws OXException
     */
    int getShard(int userId, int cid) throws OXException;

    /**
     * Get the shard for the specified email address
     *
     * @param email The email address
     * @return The shard identifier
     * @throws OXException
     */
    int getShard(String email) throws OXException;

    /**
     * Updates the given shard based on the definition in sharddbChangeLog.xml
     *
     * @param shardId The identifier of the shard that should be created
     * @throws OXException
     */
    void updateShardSchema(int shardId) throws OXException;

    /**
     * Updates all currently existing shard schemas based on the definition in sharddbChangeLog.xml
     *
     * @throws OXException
     */
    void updateAllShardSchemas() throws OXException;
}
