/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.guard.validator;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.server.connectionPooling.HttpConnectionPoolService;
import com.openexchange.guard.util.Core;

public class Normalizer {

	private static Logger logger = LoggerFactory.getLogger(Normalizer.class);

	public static String normalize (String data)
	{
		try {
			JsonParser parser = new JsonParser();
			JsonObject json = (JsonObject) parser.parse(data);
			Gson gson = new Gson();
			return (gson.toJson(normalize(json)));
		} catch (Exception ex) {
			logger.error("Error normalizing data", ex);
			return(data);
		}
	}

	/**
	 * Send string to backend for normalization.  Primarily for PGP Inline
	 * @param data
	 * @return
	 * @throws Exception
	 */
	public static String normalizeString (String data) {
	    try {
    	    JsonObject content = new JsonObject();
            content.addProperty("content", data);
            JsonObject newcontent = putRequest (content);
            String emailContent = newcontent.get("content").getAsString();
            return (emailContent);
	    } catch (Exception e) {
	        logger.error("Problem normalizing string ", e);
	        return (data);
	    }
	}

	/**
	 * Send email JSON to OX backend for normalization (strip scripts, etc)
	 * @param json
	 * @return
	 */
	public static JsonObject normalize (JsonObject json) {
		if (json.has("attachments")) {
			JsonArray attachments = json.get("attachments").getAsJsonArray();
			JsonArray newattach = new JsonArray();
			boolean hasHTML = false;
			int plainTextIndex = 0;
			for (int i = 0; i < attachments.size(); i++) {
				JsonObject attach = attachments.get(i).getAsJsonObject();
				if (attach.has("content")) {
					if (!attach.get("content").isJsonNull()) {
						try {
							String data = attach.get("content").getAsString();
							JsonObject content = new JsonObject();
							content.addProperty("content", data);
							JsonObject newcontent = putRequest (content);
							String emailContent = newcontent.get("content").getAsString();
							try {
								String type = attach.get("content_type").getAsString();
								if (type.contains("plain")) {  // If plaintext, save index in case no HTML
									plainTextIndex = i;
								} else {
									if (type.contains("html") || (type.contains("alternative"))) {
                                        hasHTML = true;
                                    }
								}
							}
							catch (Exception e) {
								logger.error("Error getting content_type", e);
							}
							attach.remove("content");
							attach.addProperty("content", emailContent);
						} catch (Exception ex) {
							logger.error("Error normalizing data", ex);
						}
					}
					newattach.add(attach);
				}
			}
		/** Currently disable HTML conversion.  Done in UI
		 *
		  	if (!hasHTML) {  // If no HTMl available, convert the plaintext to HTML for display

				JsonObject attach = attachments.get(plainTextIndex).getAsJsonObject();
				String emailContent = attach.get("content").getAsString();
				emailContent = plainTextConvert (emailContent);
				attach.remove("content_type");
				attach.addProperty("content_type", "text/html");
				attach.remove("content");
				attach.addProperty("content", emailContent);
			}
			**/

		}
		return (json);
	}

	private static String plainTextConvert (String content)
	{
		content = content.replace("<body>", "").replace("</body>", "").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<br/>").replace("\"", "&quot;");
		return (content);
	}

	 /**
     * Actual send of data to OX Backend
     *
     * @param data String of JSON data to send
     * @param database The ID of the database
     * @param cid ContextId if pertinent. 0 if not
     * @param write Write or read ony
     * @return
     * @throws Exception
     */
    private static JsonObject putRequest(JsonObject content) throws Exception {
    	String data = content.toString();
        //CloseableHttpClient httpClient = OxDbConn.httpClient;
    	CloseableHttpClient httpClient  = HttpConnectionPoolService.getClient();
        HttpContext context = HttpClientContext.create();
        String url = "http" + (Config.backend_ssl ? "s" : "") + "://" + Config.getOxBackend() + ":" + Config.ox_backend_port + "/preliminary/htmlproc/v1/sanitize";
        HttpPut putRequest = new HttpPut(url);
        StringEntity entity = new StringEntity(data, "UTF-8");
        entity.setContentType("text/javascript;charset=UTF-8");
        putRequest.addHeader("accept", "application/json");
        putRequest.addHeader("Authorization", "Basic " + Config.getBasicAuthenticationEncoding());
        putRequest.setHeader("User-Agent", Config.apiUserAgent);
        putRequest.setEntity(entity);
        CloseableHttpResponse response = httpClient.execute(putRequest, context);
        JsonObject result = null;
        if (response.getStatusLine().getStatusCode() != 200) {
            try {
                result = Core.getJson(response);
            } catch (Exception ex) {
            	try {
            		EntityUtils.consume(response.getEntity());
            		putRequest.releaseConnection();
            		response.close();
            	} catch (Exception e2) {
            		logger.error("unable to close http stream after error", e2);
            	}
                throw new Exception("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            response.close();
            putRequest.releaseConnection();
            return (result);

        }
        result = Core.getJson(response);
        EntityUtils.consume(response.getEntity());
        response.close();
        putRequest.releaseConnection();
        return (result);

    }
}
