/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.validator;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;

import org.apache.commons.net.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.guard.config.Config;
import com.openexchange.guard.encr.GuardKeys;


public class Keyman {

	private static Logger logger = LoggerFactory.getLogger(Keyman.class);
	
    public static PrivateKey priv = null;

    public static PublicKey pub = null;

    private static PublicKey getPubKeyFromString(String publickey) {
        KeyFactory kf;
        try {
            kf = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec ks = new X509EncodedKeySpec(Base64.decodeBase64(publickey));
            PublicKey pubkey = kf.generatePublic(ks);
            return (pubkey);
        } catch (Exception e) {
            logger.error("E", e);
        }
        return (null);

    }

    private static PrivateKey getPrivateKeyFromString(String privatekey, String salt) {
        try {
            GuardKeys keys = new GuardKeys();
            keys.setEncodedPrivate(privatekey);
            keys.setSalt(salt);
            PrivateKey priv = keys.getDecodedPrivate(Config.mpass);
            return (priv);
        } catch (Exception ex) {
            logger.error("Error retrieving private key", ex);
        }
        return (null);
    }

    private static void loadKeys() {
        Path privpath = Paths.get(Config.getRoot() + "private_dns_key");
        Path pubpath = Paths.get(Config.getRoot() + "public_dns_key");
        try {
            List<String> lines = Files.readAllLines(privpath, StandardCharsets.UTF_8);
            String salt = lines.get(0);
            priv = getPrivateKeyFromString(lines.get(1), salt);
            lines = Files.readAllLines(pubpath, StandardCharsets.UTF_8);
            for (String line : lines) {
                if (line.length() > 1) {
                    pub = getPubKeyFromString(line);
                }
            }
        } catch (IOException e) {
        	logger.error("Error loading key pair", e);
        }

    }

    public static PrivateKey getPriv() {
        if (priv == null)
            loadKeys();
        return (priv);
    }

    public static PublicKey getPublic() {
        if (priv == null)
            loadKeys();
        return (pub);
    }
}
