/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.tester;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.Security;
import java.util.ArrayList;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.database.OGInit;
import com.openexchange.guard.database.RecipKey;
import com.openexchange.guard.encr.GuardKeys;
import com.openexchange.guard.pgp.PGPPublicHandler;
import com.openexchange.guard.pgp.PGPResult;
import com.openexchange.guard.pgp.PGPUtils;
import com.openexchange.guard.pgp.PgpHandler;
import com.openexchange.guard.pgp.PgpKeys;
import com.openexchange.guard.server.connectionPooling.HttpConnectionPoolService;

public class Test {

    public static void main(String[] args) throws Exception {
        // TODO Auto-generated method stub

        //OxDbConn.init();
        HttpConnectionPoolService.initialize();
        OGInit.initGuardDatabase();
        Config.loadConfig();
        Security.addProvider(new BouncyCastleProvider());

        // Pull a guard key of a member.
        Access acc = new Access();
        GuardKeys key = acc.getKeys(3, 1);


        if (1 == 1) {
            System.exit(0);
        }
        // PGP encryption requires a list of people that can read the file
        RecipKey recip = new RecipKey(key);
        ArrayList<RecipKey> list = new ArrayList<RecipKey>();
        list.add(recip);

        String test = "This is a test string";
        ByteArrayInputStream in = new ByteArrayInputStream(test.getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        // Encrypt without signing
        PGPUtils.encrypt(out, in, "test.pgp", list, true, true);

        // Encrypt with signing.  Needs the senders key and password for the signing
    //    PGPUtils.signEncryptFile(out, in, "test.pgp", list, key, "ghill1", true, true);

        String encrypted = new String(out.toByteArray());
        System.out.println(encrypted);
        ByteArrayInputStream encoded = new ByteArrayInputStream(out.toByteArray());
        ByteArrayOutputStream decoded = new ByteArrayOutputStream();

        // Decoding with or without signature is same call
        PGPResult result = PGPUtils.decryptFile(encoded, decoded, 3, 1, "oxtest", true);
        String dec = new String (decoded.toByteArray());
        System.out.println(dec);
        // Result returns signing information and error if any
        System.out.println(result.getJsonString());

        if (1 == 1) {
            return;
        }
        GuardKeys key2 = new GuardKeys();
        System.out.println(key.exportPGPPublicKeyRing());

        System.out.println(PgpHandler.getKeyInfo(key2.pubring));
        System.out.println(key2.exportPGPPublicKeyRing());
        GuardKeys signtest = PGPPublicHandler.getPGPKeysFromEmail("tempdocgreg@gmail.com", 3, 1);
        PGPPublicKeyRing newring = PgpKeys.sign(key.getPGPSecretKey(), key.getPGPSignKey("ghill1"), signtest.pubring);
        System.out.println(PgpHandler.getKeyInfo(newring));
        key2.pubring = newring;
        System.out.println(key2.exportPGPPublicKeyRing());


    }

    public static String readTestFile() {
        try {
            BufferedReader br = new BufferedReader(new FileReader("c:\\testkey2.asc"));
            StringBuilder sb = new StringBuilder();
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            return (sb.toString());
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return ("");

    }

}
