package com.openexchange.guard.support;

import java.util.ArrayList;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.database.model.DeletedKey;
import com.openexchange.guard.database.model.Email;
import com.openexchange.guard.database.repositories.DeletedKeyRepository;
import com.openexchange.guard.database.repositories.EmailRepository;
import com.openexchange.guard.database.repositories.GuardKeysRepository;
import com.openexchange.guard.encr.GuardKeys;


public class UserDeleter {

    /**
     * Deleting an existing OX Guard
     *
     * When deleting an user, all related Keys will be deleted from the main tables.
     * In addition the user's keys are backed up in the DeletedKeyTable and could be
     * exposed for later usage using the support-API
     *
     * @param userId The user's id
     * @param contextId The context id
     * @throws Exception
     */
    public void Delete(int userId, int contextId) throws Exception {

        //1) Create deleted Key entries
        //TODO: move getAllKeys into an appropriated repository class
        Access acc = new Access();
        ArrayList<GuardKeys> keys = acc.getAllKeys(userId, contextId);
        //Get user's key and create DeletedKey's objects for backing up keys even if the user
        //has been already deleted
        ArrayList<DeletedKey> deletedKeys = new ArrayList<DeletedKey>();
        for(GuardKeys key : keys){
                deletedKeys.add(new DeletedKey(key));
        }
        if(deletedKeys.size() > 0 ) {
            DeletedKeyRepository deletedKeyRepository =
                new DeletedKeyRepository();
            deletedKeyRepository.Create(deletedKeys.toArray(new DeletedKey[deletedKeys.size()]));
        }

       //2)remove from Key Tables
       new GuardKeysRepository().Delete(keys.toArray(new GuardKeys[keys.size()]));

       //3) remove from email mappings
       new EmailRepository().Delete(new Email(null,userId,contextId));
    }
}
