package com.openexchange.guard.server.connectionPooling;

import org.apache.http.pool.PoolStats;


/**
 * Provides statistics for a set of PoolStats
 */
class SummarizedHttpPoolingStats implements HttpPoolingStats {

    private final PoolStats[] stats;

    /**
     * Constructor
     * @param stats the set of stats to summarize
     */
    SummarizedHttpPoolingStats(PoolStats...stats){
        if(stats == null) {
            throw new IllegalArgumentException("parameter stats must not be null");
        }

        this.stats = stats;
    }

    @Override
    public int getAvailable() {
        int available = 0;
        for(PoolStats stat  : stats){
            available += stat.getAvailable();
        }
        return available;
    }

    @Override
    public int getLeased() {
        int leased = 0;
        for(PoolStats stat  : stats){
            leased += stat.getLeased();
        }
        return leased;
    }

    @Override
    public int getPending() {
        int pending = 0;
        for(PoolStats stat  : stats){
            pending += stat.getPending();
        }
        return pending;
    }
}
